/*  Vdisc.h   		*/

#include <stdio.h>
#include "video_conf.h"
#include "videoserver.h"

#define VDSC_STOPPED 0
#define NO_WAIT      0
#define WAIT         1
#define MaxDiscs     10
#define MaxRpds      10

VDISC VCONF_DEVTABLE 	vdt;  /* video device table  */
VDISC CONNECTION 	v$server;
VDISC int		v$code, v$val, v$err;
VDISC char		v$line[128];

typedef struct _Vdisc{
	int		port;
	int		operation;
	int		state;
	int		switcher;  /* codes switcher state 1-4 */
	Element		*controlling_element;
} Vdisc;

VDISC Vdisc vdsc, *disc;  /* VDISC is currently set local in main.c */

typedef struct _rpdspec {
			int	number;
			char	*volume;
			char	*devname;
		  } Rpdspec;

VDISC Rpdspec  *rpdinfo[MaxRpds];
VDISC int  u$Rpdcount, u$Disccount;


#define Perform PerformVideoService(v$server,v$line,&vdt,&v$code,&v$val,&v$err)
#define Vdisc_indexon(num)   sprintf(v$line,"rpd-%d indexon\n",num); Perform

#define Vdisc_indexoff(num)  sprintf(v$line,"rpd-%d indexoff\n",num); Perform

#define Vdisc_audio1on(num)   \
		sprintf(v$line,"rpd-%d a1on\n",num); Perform
#define Vdisc_audio1off(num)  \
		sprintf(v$line,"rpd-%d a1off\n",num); Perform    
		
#define Vdisc_audio2on(num)   \
		sprintf(v$line,"rpd-%d a2on\n",num); Perform
#define Vdisc_audio2off(num)  \
		sprintf(v$line,"rpd-%d a2off\n",num);  Perform
		
#define Vdisc_load(num)	    \
		sprintf(v$line,"rpd-%d load\n",num); Perform   
		
#define Vdisc_unload(num)	    \
		sprintf(v$line,"rpd-%d unload\n",num); Perform
		
#define Vdisc_reset(num)	    \
		sprintf(v$line,"rpd-%d reset\n",num); Perform

#define Vdisc_getframe(num)	    \
		sprintf(v$line,"rpd-%d @\n",num); Perform

#define Vdisc_fveryfast(num)  \
		sprintf(v$line,"rpd-%d fvfast\n",num); Perform
		
#define Vdisc_ffast(num)	    \
		sprintf(v$line,"rpd-%d ffast\n",num); Perform
		
#define Vdisc_fplay(num)	    \
		sprintf(v$line,"rpd-%d fplay\n",num); Perform
		
#define Vdisc_fslow(num)	    \
		sprintf(v$line,"rpd-%d fslow\n",num); Perform
		
#define Vdisc_fveryslow(num)  \
		sprintf(v$line,"rpd-%d fmin\n",num); Perform
		
#define Vdisc_fstep(num)	    \
		sprintf(v$line,"rpd-%d fjog\n",num); Perform
		
#define Vdisc_rfast(num)      \
		sprintf(v$line,"rpd-%d rfast\n",num); Perform
		
#define Vdisc_rveryfast(num)  \
		sprintf(v$line,"rpd-%d rvfast\n",num); Perform
		
#define Vdisc_rplay(num)	    \
		sprintf(v$line,"rpd-%d rplay\n",num);  Perform
		
#define Vdisc_rslow(num)	    \
		sprintf(v$line,"rpd-%d rslow\n",num); Perform
		
#define Vdisc_rveryslow(num)  \
		sprintf(v$line,"rpd-%d rvslow\n",num); Perform
		
#define Vdisc_rstep(num)	    \
		sprintf(v$line,"rpd-%d rjog\n",num); Perform
		
#define Vdisc_still(num)	    \
		sprintf(v$line,"rpd-%d still\n",num); Perform
		
#define Vdisc_stop(num) 	    \
		sprintf(v$line,"rpd-%d still\n",num);  Perform
		
#define Vdisc_setspeed(num,speed)  \
		sprintf(v$line,"rpd-%d %s\n",num,speed); Perform
		
#define Vdisc_playseg(num,in,out,wait)  \
	sprintf(v$line,"rpd-%d segplay %d %d %d\n",num,in,out,wait); Perform
		
#define Vdisc_search(num,f,wait)  \
		sprintf(v$line,"rpd-%d search %d %d\n",num,f,wait); Perform
		


#define Swtr_reset	\
		sprintf(v$line,"swtr reset\n"); Perform
		

#define Swtr_inquire	\
		sprintf(v$line,"swtr inquire\n"); Perform
		

#define Swtr_all(num)	\
		sprintf(v$line,"swtr all %d\n",num); Perform
		

#define Swtr_video(num)	\
		sprintf(v$line,"swtr video %d\n",num); Perform
		

#define Swtr_audio2(num)	\
		sprintf(v$line,"swtr left %d\n",num); Perform
		

#define Swtr_audio1(num)	\
		sprintf(v$line,"swtr right %d\n",num); Perform
		


#define Server_lock	sprintf(v$line,"server lock\n"); Perform
		

#define Server_unlock   sprintf(v$line,"server unlock\n"); Perform
		

#define Server_reset    sprintf(v$line,"server reset\n"); Perform
		

