
/* 

XVideo.h - macros and definitions for video windows
	   RMS 6/10/87

	NOTE: users must have the line "#define SCOPE extern"
	before #include-ing this file, as in:

#define SCOPE extern
#include "XVideo.h"

*/

#ifndef XVIDEO_H
#define XVIDEO_H

#undef FALSE
#define	FALSE	0
#undef TRUE
#define TRUE 1
#define UNDEFINED -1

/* define shared external variables; currently, all live in Xvid.c */

SCOPE	int		VideoDevice;	/* TRUE if we can do video */
SCOPE	Pixmap		vback_pixmap,
			live_pixmap,
			still_pixmap,
			scale_pixmap;
SCOPE	char *		VideoLabel;
SCOPE	Font		VideoFont;

#define VLABEL(s)	( VideoDevice ? (VideoLabel = NULL) : (VideoLabel = s) )
#define VNOLABEL	VideoLabel = NULL

#define	DEF_VID_FONT	"9x15"

/* the following PLX id is not listed anywhere under V10R4;
	1100-1199 is the Parallax address space */

#define PLX_BASE	1100
#define DISPLAY_IS_PLX	( ((DisplayType()-PLX_BASE)>=0 && \
			(DisplayType()-PLX_BASE)<100) ? TRUE : FALSE )

/* video function return codes */

#define	SUCCESS		0
#define FAILURE		-1

/* standard video frame size for the Parallax */

#define VIDEO_WIDTH	640
#define VIDEO_HEIGHT	482

/* assorted macros for ensuring proper placement of video windows */

#define ODD(n) 		( ((n)%2) ? TRUE : FALSE )
#define MOD_16(n) 	( ((n)%16) ? FALSE : TRUE )
#define ROUND_16(n)	( ((n)+8) & (~0xf) )
#define DOWN_TO_16(n)	( (n) & (~0xf) )
#define UP_TO_16(n)	( ((n)+0xf) & (~0xf) )

#endif XVIDEO_H
