
/* hash.h: defs for K&R hash table manager
 * RMS 6/15/87
 */

#ifndef	HASH_H
#define HASH_H


typedef struct _nlist 		/* your basic hash table entry */
{			
	char		*name;	/* the english name (manages own storage) */
	char		*value;	/* a synonym (optional; manages own storage) */
	int		def;	/* integer equivalent for name */
	char		*ptr;	/* a pointer to anything - USER maintained! */
	struct _nlist	*next;	/* the next node in the list */
} HashNode, *HashNodePtr;

typedef struct
{
	char 		*name;	/* the name of this hash table */
	int		size;	/* the number of slots in the table */
	HashNodePtr	*table;	/* the actual table; array is table[size] */
} HashTable, *HashTablePtr;

#define DEF_HASHSIZE	100	/* if you give a size of 0 to hash_create() */

HashTablePtr	hash_create();	
int		hash_destroy();
HashNodePtr	hash_install();
HashNodePtr	hash_lookup();
int		hash_remove();
int		hash_dump();
int		hash_load();
int		hash_apply();

#endif HASH_H
