
environment Xtest
{

	-- declarations section; all of the C globals which can be accessed

	Cint	theTextBuffer;

	Cfunc	theObj() returns Cstr;
	Cfunc	theEnv() returns Cstr;
	Cfunc	theCode() returns Cstr;

	Cfunc	XtTextUnsetSelection( Cint );
	Cfunc	GetTextEditorPos( Cint, Cstr, Cstr );
	Cfunc	SetTextEditorPos( Cint, Cint, Cint );
	Cfunc	GetTextEditorSelection( Cstr ) returns Cint;
	Cfunc	TextEditorReplace( Cint, Cint, Cint, Cstr );
	Cfunc	QueryWindow( Cint, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	ChangeWindow( Cint, Cint, Cint );
	Cfunc	QueryHeight( Cint ) returns Cint;
	Cfunc	XQueryWidth( Cstr, Cint ) returns Cint;
	Cfunc	GXCOPY() returns Cint;
	Cfunc	ALLPLANES() returns Cint;
	Cfunc	myWindow() returns Cint;
	Cfunc	GetAFont( Cstr ) returns Cint;
	Cfunc	ShowText( Cint, Cint, Cint, Cstr, Cint, Cint, Cint );
	Cfunc	theRoot() returns Cint;	
	Cfunc	WhitePM() returns Cint;
	Cfunc	BlackPM() returns Cint;
	Cfunc	MakeWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	RegisterWindow( Cint, Cstr );
	Cfunc	MapWindow( Cint );
	Cfunc	MapChildren( Cint );
	Cfunc	UnMap( Cint );
	Cfunc	ClearWindow( Cint );
	Cfunc	strlen( Cstr ) returns Cint;
	Cfunc	FlushEvents();
	Cfunc	Beep();
	Cfunc	MoveWindow( Cint, Cint, Cint );
	Cfunc	MakeButton( Cint, Cint, Cint, Cstr ) returns Cint;
	Cfunc	MakeButtonBox( Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	AddToButtonBox( Cint, Cint );
	Cfunc	MakeAskFor( Cint, Cstr, Cstr, Cint, Cint ) returns Cint;
	Cfunc	GetAskForString( Cint ) returns Cstr;
	Cfunc	MakeTextEditor( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	XtSendDestroyNotify( Cint );
	Cfunc	XDestroyWindow( Cint );
	Cfunc	Quit();
	Cfunc	MakeMenuBarWindow( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	MenuBarHeight() returns Cint;
	Cfunc	SetIconWindow( Cint, Cint );
	Cfunc	IconSwitch( Cint );
	Cfunc	MakePixmap( Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XPixmapPut( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );
	Cfunc	MakeCursor( Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XDefineCursor( Cint, Cint );
	Cfunc	XUndefineCursor( Cint );
	Cfunc	GetColor( Cstr ) returns Cint;

	Cfunc	RegisterTW( Cint );
	Cfunc	DeRegisterTW( Cint );
	Cfunc	WindowFromTW( Cint ) returns Cint;

	Cfunc	TextCreate( Cint, Cint, Cint, Cint, Cint, 
			Cstr, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	TextDestroy( Cint );
	Cfunc	TextClear( Cint );
	Cfunc	TextRedisplay( Cint );
	Cfunc	TextPutString( Cint, Cstr );
	Cfunc	TextPutChar( Cint, Cint );
	Cfunc	TextPutLine( Cint, Cstr );
	Cfunc	TextFlush( Cint );	

	var 	theResult;
	var 	theFont;
	var	theEditor;
	var	theMenu;
	var	theCursor;
	var	TextWinPtr;
	var	theTextWindow;

	-- end of C declarations

	on OpenEnv
	{
		put GetAFont( "timrom12b" ) into theFont;
		put MakeCursor( "left_ptr.cursor", "left_ptr_mask.cursor",
			"black", "white" ) into theCursor;
		XDefineCursor( theRoot(), theCursor );
		put TextCreate( 80,24,750,100,theRoot(),
			"8x13",2,0,1,BlackPM(),1 ) into TextWinPtr;
		RegisterTW( TextWinPtr );	-- VERY IMPORTANT!!
		put WindowFromTW( TextWinPtr ) into theTextWindow;
		MapWindow( theTextWindow );

		put MakeButtonBox( theRoot(), 550,100,300,100 ) into bbw;
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Beep" ) );
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Quit" ) );

		MapWindow( bbw );
		MapChildren( bbw );		
		FlushEvents();
	}

	object Beep 
	{ 
		on Activate 
		{ 
			Beep(); 
			put 35325 into a;
			put 4.7 into b;
			put 1 into c;
			if( (a > b) AND (b > c) )
			{
				put "AND op working!" into text;
				TextPutLine( TextWinPtr, text );
			}
			else
			{
				put "AND op NOT working!" into text;
				TextPutLine( TextWinPtr, text );
			}
			if( (b > a) OR (b > c) )
			{
				put "OR op working!" into text;
				TextPutLine( TextWinPtr, text );
			}
			else
			{
				put "OR op NOT working!" into text;
				TextPutLine( TextWinPtr, text );
			}
			if( NOT(b > a) )
			{
				put "NOT op working!" into text;
				TextPutLine( TextWinPtr, text );
			}
			else
			{
				put "NOT op NOT working!" into text;
				TextPutLine( TextWinPtr, text );
			}
			if( c )
			{
				put "single-var expr working!" into text;
				TextPutLine( TextWinPtr, text );
			}
			else
 			{
				put "single-var expr NOT working!" into text;
				TextPutLine( TextWinPtr, text );
			}
		} 
	}

	object Quit { on Activate { Quit(); } }

}
