

environment video
{

	-- declarations section; all of the C globals which can be accessed

	Cint	theTextBuffer;

	Cfunc	theObj() returns Cstr;
	Cfunc	theEnv() returns Cstr;
	Cfunc	theCode() returns Cstr;

	Cfunc	XSync( Cint );
	Cfunc	XtTextUnsetSelection( Cint );
	Cfunc	GetTextEditorPos( Cint, Cstr, Cstr );
	Cfunc	SetTextEditorPos( Cint, Cint, Cint );
	Cfunc	GetTextEditorSelection( Cstr ) returns Cint;
	Cfunc	TextEditorReplace( Cint, Cint, Cint, Cstr );
	Cfunc	QueryWindow( Cint, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	ChangeWindow( Cint, Cint, Cint );
	Cfunc	QueryHeight( Cint ) returns Cint;
	Cfunc	XQueryWidth( Cstr, Cint ) returns Cint;
	Cfunc	GXCOPY() returns Cint;
	Cfunc	ALLPLANES() returns Cint;
	Cfunc	myWindow() returns Cint;
	Cfunc	GetAFont( Cstr ) returns Cint;
	Cfunc	ShowText( Cint, Cint, Cint, Cstr, Cint, Cint, Cint );
	Cfunc	theRoot() returns Cint;	
	Cfunc	WhitePM() returns Cint;
	Cfunc	BlackPM() returns Cint;
	Cfunc	MakeWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	RegisterWindow( Cint, Cstr );
	Cfunc	MapWindow( Cint );
	Cfunc	MapChildren( Cint );
	Cfunc	UnMap( Cint );
	Cfunc	ClearWindow( Cint );
	Cfunc	strlen( Cstr ) returns Cint;
	Cfunc	FlushEvents();
	Cfunc	Beep();
	Cfunc	MoveWindow( Cint, Cint, Cint );
	Cfunc	MakeButton( Cint, Cint, Cint, Cstr ) returns Cint;
	Cfunc	MakeButtonBox( Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	AddToButtonBox( Cint, Cint );
	Cfunc	MakeAskFor( Cint, Cstr, Cstr, Cint, Cint ) returns Cint;
	Cfunc	GetAskForString( Cint ) returns Cstr;
	Cfunc	MakeTextEditor( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	XtSendDestroyNotify( Cint );
	Cfunc	XDestroyWindow( Cint );
	Cfunc	Quit();
	Cfunc	MakeMenuBarWindow( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	MenuBarHeight() returns Cint;
	Cfunc	SetIconWindow( Cint, Cint );
	Cfunc	IconSwitch( Cint );
	Cfunc	MakePixmap( Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XPixmapPut( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );
	Cfunc	MakeCursor( Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XDefineCursor( Cint, Cint );
	Cfunc	XUndefineCursor( Cint );
	Cfunc	GetColor( Cstr ) returns Cint;

	Cfunc	RegisterTW( Cint );
	Cfunc	DeRegisterTW( Cint );
	Cfunc	WindowFromTW( Cint ) returns Cint;

	Cfunc	TextCreate( Cint, Cint, Cint, Cint, Cint, 
			Cstr, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	TextDestroy( Cint );
	Cfunc	TextClear( Cint );
	Cfunc	TextRedisplay( Cint );
	Cfunc	TextPutString( Cint, Cstr );
	Cfunc	TextPutChar( Cint, Cint );
	Cfunc	TextPutLine( Cint, Cstr );
	Cfunc	TextFlush( Cint );	
	
	Cfunc	XCreateVideoWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	XStartVideo( Cint, Cint, Cint, Cint );
	Cfunc	XStillVideo( Cint, Cint, Cint, Cint, Cint, Cint, Cint );
	Cfunc	XScaleVideo( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );

	Cfunc	InitVideoDevs() returns Cint;
	Cfunc	GetDefaultRPD() returns Cint;
	Cfunc	RPDreset( Cint ) returns Cint;
	Cfunc	RPDcmd( Cint, Cstr ) returns Cint;
	Cfunc	RPDsearch( Cint, Cint, Cint ) returns Cint;
	Cfunc	RPDsegplay( Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	RPDgetframe( Cint ) returns Cint;
	Cfunc	RPDvarspeed( Cint, Cstr ) returns Cint;
	Cfunc	RPDjog( Cint, Cint ) returns Cint;
	
	-- end of C declarations

	var 	theFont;
	var	theCursor;
	var	theRPD;

	function GetIconWindowSize( iw, ih, name, f, width, height )
	{
		put XQueryWidth( name, f ) into strWidth;
		put QueryHeight( f ) into strHeight;
		put (strWidth+20) into w;
		if( (iw+20) > w )
			{ put (iw+20) into w; }
		put ((strHeight+ih)+30) into h;
		put w into width;	-- return this value
		put h into height;	-- return this value
	}

	function PlotIcon( window, pm, iw,ih, name, f )
	{
		QueryWindow( window, w,h,x,y, bdr, mapped, type, assoc );
		put 10 into destSX;
		put (ih+20) into destSY;
		put ((w-iw)/2) into destIX;  -- center icon width-wise
		put 10 into destIY;
		XPixmapPut( window, 0,0,destIX,destIY,iw,ih,pm,
			GXCOPY(), ALLPLANES() );
		ShowText( window, destSX,destSY, name, strlen(name), f, 0 );
	}

	on OpenEnv
	{
		if( InitVideoDevs() < 0 )
			{ Quit(); }
		put GetDefaultRPD() into theRPD;
		put GetAFont( "timrom10b" ) into theFont;
		put MakeCursor( "left_ptr.cursor", "left_ptr_mask.cursor",
			"black", "white" ) into theCursor;
		XDefineCursor( theRoot(), theCursor );
		put ("setframe "&6988) into theMsg;
		send "cmd indexon" to "videodisc";
		send theMsg to "vidwin";
		send "create" to "vidwin";
		FlushEvents();
	}

	object videodisc
	{
		on reset
		{
			RPDreset( theRPD );
		}
		on cmd		str
		{
			RPDcmd( theRPD, str );
		}
		on search	frame,wait
		{
			RPDsearch( theRPD, frame, wait );
		}
		on segplay	in,out,wait
		{
			RPDsegplay(theRPD,in,out,wait);
		}
		on getframe	replyobj,replyhandler
		{
			put ((replyhandler&" ")&RPDgetframe(theRPD)) into theMsg;
			send theMsg to replyobj;
		}
		on varspeed	str
		{
			RPDvarspeed( theRPD, str );
		}
		on jog		num
		{
			RPDjog( theRPD, num );
		}
	}

	object vidwin
	{
	var	inited;
	var	myFrame;

		on create
		{
			if( inited = 0 )
			{
				put XCreateVideoWindow( theRoot(), 100,100,
					640,482,2,WhitePM(),BlackPM() )
						into theWin;
				RegisterWindow( theWin, theObj() );
				put (("SetIcon "&theWin)&" `Video Window`")
					into theMsg;
				send theMsg to "IconWindow";
				MapWindow( myWindow() );
				put 1 into inited;
			}
		}

		on setframe	it
		{
			put it into myFrame;
		}

		on ExposeWindow
		{
			put (("search "&myFrame)&" 1") into theMsg;
			send theMsg to "videodisc";
			QueryWindow( myWindow(), w,h,x,y,bdr,mapped,type,assoc );
			XScaleVideo( myWindow(), 0,0,640,482,0,0,w,h );
			XSync(0);
			send "varspeed fplay" to "videodisc";
		}

		on ExposeRegion
		{
			put (("search "&myFrame)&" 1") into theMsg;
			send theMsg to "videodisc";
			QueryWindow( myWindow(), w,h,x,y,bdr,mapped,type,assoc );
			XScaleVideo( myWindow(), 0,0,640,482,0,0,w,h );
			XSync(0);
			send "varspeed fplay" to "videodisc";
		}
	
		on ButtonPressed
		{
			IconSwitch( myWindow() );
		}
	}

	object IconWindow
	{
		var	myPixmap;
		var	theIcon;
		var	IconW;
		var	IconH;
		var	IconWindowW;
		var	IconWindowH;
		var	IconName;

		on SetIcon	mainWindow,theName
		{
			if( myPixmap = 0 )
			{
				put MakePixmap( "xtv.bitmap", 
					"Firebrick", "CadetBlue", IconW, IconH ) 
						into myPixmap;
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				put MakeWindow( theRoot(), 100, 100, 
					IconWindowW, IconWindowH,
					2, BlackPM(), WhitePM() )
						into theIcon;
				RegisterWindow( theIcon, theObj() );
			}
			else	-- icon already made, name may have changed
			{
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				ChangeWindow( theIcon, IconWindowW, IconWindowH );
			}
			put theName into IconName;
			SetIconWindow( mainWindow, myWindow() );
		}

		on ExposeWindow
		{
			PlotIcon( myWindow(), myPixmap, IconW, IconH, IconName, theFont );
		}

		on ExposeRegion
		{
			PlotIcon( myWindow(), myPixmap, IconW, IconH, IconName, theFont );
		}

		on ButtonPressed
		{
			IconSwitch( myWindow() );
		}
	}

}
