#define FAILURE 0
#define VIDBACK 0
#define SETTLE count(5000)

#define STOPPED 0
#define PAUSE 1
#define PLAYING 2

#define TIMELIMIT 60
#define TIMECTRL_WIDTH  630 /* pixels in the time control bar */
#define YES 1
#define NO 0
#define MAXMARKS 50

#define OFF 0
#define TEXT_TYPE 1
#define VIDEO_TYPE 2
#define DISP_TYPE 3
#define LINE 1
#define LOOP 2
#define BOUNCE 3
#define MAXDIMS 5

#define CalculateTime(x,dsp) (x * dsp->duration / TIMECTRL_WIDTH)  
#define MAKE16(z) (z)=((z)+8)&(~0xf)

#define addbutton(w)\
    buttons[buttoncount].name = XtAWindow;\
    buttons[buttoncount].value = (caddr_t)w;\
    buttoncount++;

#define BORDERWIDTH 1


/***************
*  Windows needed
*/
Window background; /* covers screen */
Window windowid;  /* main display window */
Window   sw, rate_scr;  /*scroll windows */
Window timewindow;  /* time display */
Window butbox;  /* button box window */
Window fwd, rev, stp, mrk;  /* command button windows */
Window dw; /* filename dialog */
Window subtitles; 


/********************
* video window stuff 
*/

#define FAILURE 0
#define VIDBACK 0
Window VideoWindow;
Window v1,v2;
OpaqueFrame	frame;
int disc = -1;
int sframe = 2001;



/************************
*  Event data
*
*	This union is needed to get at the details of an event.  
*	The fact that the Xevent structure and the particular
*	event description structures occupy the same memory is
*	not described in the Xlib documentation.  The detail fields
*	of an event are accessed through this union as   
*			event.keypress.detail  
*	etc.   One other point; the input calls, XNextEvent, etc. need
*	a pointer, therefore the address of the union is passed.
*/
union evnt { XEvent                rep;
	     XKeyPressedEvent      keypress;
	     XButtonPressedEvent   buttpress;
	     XButtonReleasedEvent  buttrelease;
	     XEnterWindowEvent	   enterwin;
	     XLeaveWindowEvent	   exitwin;
	     XMouseMovedEvent      mousemove;
          } event;



/***************
*  General global vars.
*/
XEvent rp, *rep = &rp; /* global event */
Font f, tf;
int len;
char cmd[32];
char *msg[30];
int time;
int timeinc = 1;
int time_is_on = NO;
int count_marks;
int mark[MAXMARKS];
int rate;
int timer();
int tries = 0;

FILE *fp;


/**************
* Functions
*/
char *calloc();
void show();
void update_display();


/***************
*  Timer structs
*/
struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;


/************* 
*  Map struct 
*/
struct map{    struct map *next;
	       struct map *prev;
	       int time; /* to be replaced w/ posn spec on n dims */
	       long in;
	       long out;
	       long icon;
	     };
 
struct map txta, *text = &txta;
struct map vdeo, *video = &vdeo;

/******************
*  Dimension struct
*/
struct dimsum {
  float min;  /* minimum value on this dim */
  float max;
  float current; /* current pos'n on this dim */
  float range;  /* what extent is being displayed, rel. to current */
  int topology; /* LINE,LOOP,BOUNCE */
 };
	       
/********************
*  Display elements
*/
typedef struct _Dsp_ele{
  int on;  /* on the screen or not */
  int type;    /* text, video, etc. */
  int state;   /* video playing or not */
  int geom;    /* LINE, LOOP, BOUNCE (this should be attached to dims? */
  struct map *map;  /* head of item list */
  struct map *now_showing;
  int current_frame;
  struct _Dsp_ele *next;
  struct _Dsp_ele *prev;
  Window w;
} Dsp_ele;


/*********************
*  Display
*/
typedef struct _Display{
  Dsp_ele *ele;  /* list of display elements */
  int duration; /* how many clock ticks at 1/30th sec */
  int ndims;
  struct dimsum dims[MAXDIMS];
} Disp;


/**************
*  Test parts 
*/
Dsp_ele vdpart = {OFF,VIDEO_TYPE,STOPPED,LOOP};
Dsp_ele *vidpart = &vdpart;
Dsp_ele txpart = {OFF,TEXT_TYPE,STOPPED,LOOP};
Dsp_ele *txtpart = &txpart;
Disp dsplay, *display = &dsplay;



/***************************************************
*   Filename Dialog stuff 
*/
DialogButton dbuttons;
static char bname[] = "OK";

DialogValue dvalue;

static char label[] = "Enter filename:";

static char instring[80];

static Arg dialogArgs[] = {
    {XtADialogValue, (caddr_t) &dvalue},
    {XtADialogButtons, (caddr_t) &dbuttons},
    {NULL, NULL}	/* needed to terminate argument list */
};

/****************
*  Dialog button 
*/
static int FilenameAction()
{
    char s[256];
    int n = 0;
    struct map *tmp;
    int lastout = 0;
    int unit;

    printf("Filename: %s\n",dvalue.string);

    if((fp = fopen(dvalue.string, "r")) == NULL){
      printf("Problem opening %s\n",dvalue.string);
      exit(1);
    }


    text->next = 0;
    text->prev = 0;
    text->time = n++;
    text->in = ftell(fp);
    if(fgets(s,256,fp) == NULL){
      printf("Failed on first string\n");
      exit(1);
    }
    text->out = ftell(fp);
    lastout = text->out;
    
    while ( fgets(s,256,fp) != NULL){ /* End of file or error */
      tmp = (struct map *) calloc(1, sizeof(struct map));
      tmp->time = ++n;
      tmp->in = lastout;
      tmp->out = ftell(fp);
      lastout = tmp->out;
      text->prev = tmp;
      tmp->next = text;
      text = tmp;

    }

    unit = (display->duration/n);

    tmp = text;
    while(tmp != 0){
      tmp->time = tmp->time * unit;
      tmp = tmp->next;
    }

    txtpart->map = text;

    printf("Mapped %d items from %s\n",n,dvalue.string);

    XUnmapWindow(dw);

    

}







/***************************************************
*  Control button procedures  (Fwd, Rev, Stop, Mark)
*/
static void Forward()
{
if(! time_is_on){  
  time_is_on = YES; 
 }

timeinc = 1;
}

/*****************
*  Reverse
*/
static void Reverse()
{
if(! time_is_on){
  time_is_on = YES;
 }

timeinc = -1;
}



/*****************
*  Stop
*/
static void Stop()
{
time_is_on = NO;
	  sprintf(cmd,"still");
#if PLX
	  sony_cmd( disc, cmd );
	  SETTLE; SETTLE; 
#else
	  printf("Video call: %s\n",cmd);
#endif

}



/******************
*   Mark
*/
static void Mark()
{
/*if(++count_marks < MAXMARKS){
  mark[count_marks] = time;


 }
else printf("Marks array is full.\n");
*/
#if PLX
sony_close( disc );
#else
	  printf("Video call: sony_close\n");
#endif

exit(0);
}




/***********************
*  Command button labels
*/
static char mrk_label[] = "Quit";
static char fwd_label[] = "Forward";
static char rev_label[] = "Reverse";
static char stp_label[] = "Stop";




static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) fwd_label},
    {XtAFunction, (caddr_t) Forward},
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}	/* needed to terminate argument list */
};

static Arg bbarglist[] = {
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}
};








/***********************************************************************
*  Scroll Window routines (time slide, time thmb, rate slide, rate thmb)
* 
*   Time bar -- buttons 1 and 3  routine
*/
static void Scr1(scrW, cliW, intpos)
  Window scrW;
  Window cliW;
  int intpos;
{
  printf("pos %d\n",intpos);
}



/****************
*  Time bar thumb (middle button)
*/
static void Thmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{

  time = (tp/100)*display->duration;
  sprintf(msg,"Time %d   ",time);
  len = strlen(msg);

  XText(windowid,
	540,510,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
  
}



/*********************
*  Rate bar thumb routine
*/
static void RateThmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{
  tp = tp - 50;
  if (tp<0){
    timeinc = -1;
    rate = 51 + tp;
  }
  else{
    timeinc = 1;
    rate = 51 - tp;
  }
printf("%d\n",rate);
}  



/**************************
*  Scroll bar argument list
*/

static Arg scrargs[] = {
  {XtAOrientation, (caddr_t) XtAhorizontal},
  {XtAWidth, (caddr_t) 630},
  {XtAHeight, (caddr_t) 20},
  {XtABorderWidth, (caddr_t) BORDERWIDTH},
  {XtAScrollUpDownProc, (caddr_t) Scr1},
  {XtAThumbProc, (caddr_t) Thmb},
  {NULL, NULL}
};



