/* 
 * dsp1.c - remake of demo1 
 *
 * Make executable with:
 *	cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>

FILE *fp;
char *calloc();

/************* text struct */
struct txt{    struct txt *next;
	       int time;
	       long in;
	       long out;
	     } txta, *text = &txta;



/**********Dialog stuff */
DialogButton dbuttons;
static char bname[] = "OK";



DialogValue dvalue;

static char label[] = "Enter filename:";

static char instring[80];

static Arg dialogArgs[] = {
    {XtADialogValue, (caddr_t) &dvalue},
    {XtADialogButtons, (caddr_t) &dbuttons},
    {NULL, NULL}	/* needed to terminate argument list */
};

/********* Dialog button */
static int ButtonAction()
{
    char s[256];
    int n = 0;
    struct txt *tmp;
    int lastout = 0;

    printf("Filename: %s\n",dvalue.string);

    if((fp = fopen(dvalue.string, "r")) == NULL){
      printf("Problem opening %s\n",dvalue.string);
      exit(1);
    }


    text->time = n++;
    text->in = ftell(fp);
    if(fgets(s,256,fp) == NULL){
      printf("Failed on first string\n");
      exit(1);
    }
    text->out = ftell(fp);
    lastout = text->out;
    printf("First string: %s  In: %d  Out: %d\n",s,text->in,text->out);
    
    while ( fgets(s,256,fp) != NULL){ /* End of file or error */
      tmp = (struct txt *) calloc(1, sizeof(struct txt));
      tmp->time = n++;
      tmp->in = lastout+1;
      tmp->out = ftell(fp);
      lastout = tmp->out;
      text->next = tmp;
      text = tmp;
    }

    fclose(fp);

    printf("Mapped %d items from %s\n",n,dvalue.string);



  }


/*************  MAIN */
void main()
{
    Display  *d;
    Window   dw;	/* dialog window */

    d = XOpenDisplay(NULL);

    XtInitToolkit();

    dbuttons.name = bname;
    dbuttons.funct = ButtonAction;
    dbuttons.param = NULL;

    dvalue.tag = label;
    dvalue.string = instring;
    dvalue.length = 80;

    dw = XtCreateDialog(RootWindow, dialogArgs);

    /* widget clients normally position, size and map widget windows */
    XMoveWindow(dw, 100, 100);
    XMapWindow(dw);

    for(;;) {
	XEvent ev;

	XNextEvent(&ev);		/* Get next event */
	(void) XtDispatchXEvent(&ev);	/* Hand it to Toolkit Dispatcher */
    }
}
