
/* XAbsCoords.c : to/from absolute coordinates and window relative coords */

#include <stdio.h>
#include <X/Xlib.h>

#define 	FAILURE	-1
#define		SUCCESS	0

/* ********************************************************************	*/
/* FUNCTION
/* Get_Absolute_Coords(	w, rel_x, rel_y, abs_x_ptr, abs_y_ptr );
/* Window	w;		/* the window our coord is relative to */
/* int		rel_x, rel_y;	/* the coord in our window */
/* int		*abs_x_ptr, *abs_y_ptr;	/* RETURNED absolute screen coords */
/*
/* REMARKS
/* Given an x,y point in an arbitrary window on the screen, converts
/* it to absolute screen position.
/* ********************************************************************	*/

Get_Absolute_Coords( w, rel_x, rel_y, abs_x_ptr, abs_y_ptr )

	Window		w;
	int		rel_x, rel_y;
	int 		*abs_x_ptr, *abs_y_ptr;		/* RETURN */
{
WindowInfo	wi;
int		x,y;
int		nchildren;
Window		parent;
Window		*children;

	if( w == NULL ) return FAILURE;

	x = rel_x;
	y = rel_y;

	while( w!=NULL && w!=RootWindow ) {
		XQueryWindow( w, &wi );
		x += wi.x;
		y += wi.y;
		XQueryTree( w, &parent, &nchildren, &children );
		free( (Window *) children );
		w = parent;
		}

	*abs_x_ptr = x;
	*abs_y_ptr = y;

	return SUCCESS;
}


/* ********************************************************************	*/
/* FUNCTION
/* Get_Relative_Coords(	w, rel_x, rel_y, abs_x_ptr, abs_y_ptr );
/* Window	w;			/* the window we have an interest in */
/* int		*rel_x_ptr, *rel_y_ptr;	/* RETURNED coord in our window */
/* int		abs_x, abs_y;		/* the absolute screen coords */
/*
/* REMARKS
/* Given an absolute x,y point on the screen, converts it to a standard
/* coord relative to the requested window.
/* ********************************************************************	*/

int
Get_Relative_Coords( w, rel_x_ptr, rel_y_ptr, abs_x, abs_y )

	Window		w;
	int		*rel_x_ptr, *rel_y_ptr;		/* RETURN */
	int		abs_x, abs_y;
{
int x,y;

	if( w==NULL ) return FAILURE;

	Get_Absolute_Coords( w, 0,0, &x, &y );
	
	*rel_x_ptr = abs_x - x;
	*rel_y_ptr = abs_y - y;

	return SUCCESS;
}
