ROUTINE(gtds,		get data structure (given file descriptor))

# Modified on 7/31/86 by P.Tukey to remove recursion
# Modified again on 9/16/88 by D. Swayne to incorporate the changes
#	made in New S

POINTER function gtds( fdx )
integer fd

INCLUDE(struct,stack,print)
POINTER istrng
POINTER jstkgt
#automatic entry, value, p, mode, file, length, nread, stype, fd2, i, sname,np
POINTER entry, alcdir, value, p, gtds2, sgets, file, np
integer mode, length, nread, cseek, stype, copen, fd2,i, sname, fdx
integer xlen, tlen, vl, vr
define(`BADREAD',900)

  define(`NSAVE',9)define(`RECURSE',901)dnl
  define(`RESUME1',902)define(`RESUME2',903)define(`RESUME3',904)dnl
  POINTER arg1, val
  integer stack, stksiz, j0, jgot, jnew, k, rtn

  fd = fdx
  entry = entry1
  stack = -1
  stksiz = 20
  j0=jstkgt(stksiz*NSAVE,INT)-NSAVE-1
  jgot=1

  RECURSE continue

  stack = stack + 1
  if(stack > 0) { 		# Push old values onto recursion stack
	if(stack>stksiz) { 	# If stack too small, double its size
		jnew = jstkgt(stksiz*NSAVE*2,INT)-NSAVE-1
		for( k=0; k<stksiz*NSAVE; k=k+1 )
			is(jnew+k+NSAVE+1) = is(j0+k+NSAVE+1)
		j0 = jnew
		stksiz = 2*stksiz
		jgot = jgot+1
		}
	is(j0+stack*NSAVE+1) = length 
	is(j0+stack*NSAVE+2) = i
	is(j0+stack*NSAVE+3) = value
	is(j0+stack*NSAVE+4) = fd
	is(j0+stack*NSAVE+5) = fd2
	is(j0+stack*NSAVE+6) = np
	is(j0+stack*NSAVE+7) = nread
	is(j0+stack*NSAVE+8) = rtn
	is(j0+stack*NSAVE+9) = entry
	fd = arg1
	}

entry=jstkgt(LENTRY, INT)
np = sgets(fd)# name
NAME(entry) = np
call cread(fd, is(entry+1), 2, INT, nread)
if(nread < 2 )goto BADREAD
mode=MODE(entry); length=LENGTH(entry)
switch(mode) {

	case REAL, INT, LGL:
		value=jstkgt(length,mode)
		VALUE(entry)=value
		call cread(fd, is(value), length, mode, nread)
		if(nread < length)goto BADREAD

	case CHAR:
		value=jstkgt(length,INT)
		VALUE(entry)=value
		for(i=0; i<length; i=i+1) {
			is(value+i)=sgets(fd)
			if(is(value+i)==NULL) is(value+i)=istrng(EOS,1)
			}
        case NEW_CHAR:
                MODE(entry) = CHAR
                value=jstkgt(length,INT); VALUE(entry)=value
                call cread(fd, tlen, 1, INT, nread)
                if(nread != 1) goto BADREAD
                is(value) = jstkgt(tlen, CHAR)
                call cread(fd, TEXT(is(value)), tlen, CHAR, nread)
                if(nread != tlen) goto BADREAD
                for(i=1; i<length; i=i+1){
                        vl = value + i
                        vr = vl - 1
                        is(vl) = is(vr) + xlen(is(vr))  # xlen counts EOS
                        }

	case DATASET:
		file=sgets( fd); fd2 = copen(TEXT(file),READ)
		#entry=gtds2(fd2) # recursive call through gtds2
	  
		arg1 = fd2
		rtn = 1
		goto RECURSE
		RESUME1 continue
		entry = val

		NAME(entry)=np
		call cclose(fd2)

	case STACK:
		nread = cseek(fd,0,1) # remember position
		if( cseek(fd,length,0) != length)FATAL(bad seek on stack file)
		#entry = gtds2( fd ) #call itself recursively
	  
		arg1 = fd
		rtn = 2
		goto RECURSE
		RESUME2 continue
		entry = val

		NAME(entry)=np
		nread = cseek(fd, nread, 0) #and return to original position

	case STR:
		call cread(fd, stype, 1, INT, nread); if(nread < 1)goto BADREAD
		sname = sgets(fd)
		value=alcdir(length,sname,stype)
		VALUE(entry) = value; value=value+LENTRY*LHDR
		for(i=0; i<length; i=i+1) {
			#p = gtds2(fd)
	  
			arg1 = fd
			rtn = 3
			goto RECURSE
			RESUME3 continue
			p = val

			call pcopy(p, value, LENTRY, INT)
			value = value + LENTRY
			}

	case NULL, MISSING: #all done

	default:
		FATAL(gtds: bad mode for data)
		}
#return( entry )

  if( stack > 0 ) {	# Pop stack, and resume earlier call
	val = entry
	length=is(j0+stack*NSAVE+1)
	i     =is(j0+stack*NSAVE+2)
	value =is(j0+stack*NSAVE+3)
	fd    =is(j0+stack*NSAVE+4)
	fd2   =is(j0+stack*NSAVE+5)
	np    =is(j0+stack*NSAVE+6)
	nread =is(j0+stack*NSAVE+7)
	rtn   =is(j0+stack*NSAVE+8)
	entry =is(j0+stack*NSAVE+9)
	stack = stack -1
	goto (RESUME1,RESUME2,RESUME3), rtn
	}

  #call jstkrl(jgot)  # Presumably this will be done at a higher level
  return( entry )

BADREAD PRINT("gtds: error reading ", C(name))
FATAL()
return( NULL )
end

#gtds2		hide the recursion from the compiler
#POINTER function gtds2(fd)
#integer fd
#POINTER gtds
#return(gtds(fd))
#end
