divert(-1)
define(`MAINPID',0)
define(`CINTER',`INCLUDE(u/signal)


NOEXTERN
INCLUDE(u/files,u/link,u/infun)
long F77_COM(xinter)[LOUTSTR]; /* common for interface routines */
int pid;

main(argc,argv) /* main keeps running, waiting for signals and then calling interface routine */
int argc; char *argv[];
	{
	extern wakeup(), F77_NAME(wtout)();
	int i, working = 0, (*istat)(), sigpid = 0, errors; long instr;
	long F77_NAME(XNAME($1))();
	sigval=SIGTERM; /* force execution first time */
	pid=getpid(); /* my process id */
	F77_COM(infext)[2] = 0L; /* no internal functions here */
	istat=signal(SIGINT,SIG_IGN); /*istat is the status of interrupts on entry */
	REPEAT {
		setjmp(sigjmp); /* will come here on signals, including errors */
		setjmp(abtjmp); abtflag = TRUE;
		alarm(0); /* cancel any pending alarm signals */
		signal(SIGALRM,wakeup); signal(SIGTERM,wakeup); signal(SIGFPE,wakeup);
		while( sigval == SIGALRM) { /* I woke up, go to sleep again */
			alarm(LONGWAIT);
			pause();
			sigval=SIGKILL; /* pause should never return */
			}
		switch(sigval) {
		case SIGINT: if(!working)break; working=FALSE;
			instr = ON_BREAK; CALLINTER($1); break;
		case SIGFPE: fprintf(stderr,"Floating Point Exception\n");
		case SIGSERROR: if(errors++)TERMINAL($1: error in reset)
			if(!working)break; working=FALSE;
			instr=ON_ERROR; CALLINTER($1); break; /*interface wrapup*/
		case SIGTERM: /* software signal from parent */
				for(i=0; i<LOUTSTR; i=i+1) F77_COM(xinter)[i] = 0L; /*initialize interface common block*/
			if(istat != SIG_IGN) signal(SIGINT, wakeup); /* catch interrupts exc. in background */
			ifelse(index($2,r),-1,,`F77_CALL(cmnctl,char="*",char="r");')
			ifelse(index($2,w),-1,,`F77_CALL(cmnctl,char="*",char="r");')
			rdinstr( &instr );
			ifelse(index($2,g),-1,,`{extern int firtim; firtim=1; F77_CALL(zinitz);}')
			ifelse(index($2,h),-1,,`{extern int firtim; firtim=1;}')
			sigpid=mainpid; /* copy the mainpid in case it gets altered */
			working=TRUE; CALLINTER($1); working=FALSE;
			ifelse(index($2,g),-1,,`F77_CALL(zwrapz);')
			ifelse(index($2,w),-1,,`F77_CALL(cmnctl,char="*",char="w");')
			if( (int)instr != PROBLEM_DONE) F77_CALL(wtout,int=&instr);
			break;
		default: fprintf(stderr, "invalid signal: %d, to process: %d\n",sigval, getpid());
			exit(sigval);
			}
		signal(SIGINT,SIG_IGN); /* ignore interrupts while inactive */
		F77_CALL(oreset);
		sigval=SIGALRM; /* all done, go to sleep */
		errors=0;
		kill(sigpid?sigpid:mainpid, SIGTERM); 
		}
	}
F77_MAIN ')
define(`CALLINTER',`instr = F77_CALL(XNAME($1),int=&instr)')
divert(0)
