#include <stdio.h>
#include <signal.h>
#include "aed.h"
#ifndef ATT
#include <sgtty.h>
#else
#include <termio.h>
#define MIN_CHAR	1
#endif

#define NO		0
#define YES		1

#ifndef ATT
static struct sgttyb tty;
static int flags;
#else
static struct termio tty;
static unsigned short lflags;
static char omin;
#endif
static int started = 0;

startup(fcn)
int (*fcn)();
{
	int wrapup();

	signal(SIGINT, fcn ? fcn : wrapup);
#ifndef ATT
	ioctl(0, TIOCGETP, &tty);
	flags = tty.sg_flags;
#else
	ioctl(0, TCGETA, &tty);
	lflags = tty.c_lflag;
	omin = tty.c_cc[VMIN];
#endif
	graphics();
	origin(0,482);
	zoom(1,1);
	savecap();
	r_mask(ALL);
	w_mask(ALL);
	started++;
	return(1);
}


wrapup()
{
	int i;

	if(started) {
		restore();
		for(i = 0; i < 20; i++)
			putchar(ESC);
		zoom(1,1);
		origin(0,482);
		w_mask(0);
		erase();
		r_mask(ALL);
		w_mask(ALPHA);
		oldcap();
		alpha(YES);
	}
	exit();
}

raw()
{
#ifndef ATT
	tty.sg_flags |= CBREAK;
	tty.sg_flags &= ~ECHO;
	ioctl(0, TIOCSETP, &tty);
#else
	tty.c_lflag &= ~(ECHO|ICANON);
	tty.c_cc[VMIN] = MIN_CHAR;
	ioctl(0, TCSETA, &tty);
#endif
}

echo_off()
{
#ifndef ATT
	tty.sg_flags &= ~ECHO;
	ioctl(0, TIOCSETP, &tty);
#else
	tty.c_lflag &= ~ECHO;
	ioctl(0, TCSETA, &tty);
#endif
}

restore()
{
#ifndef ATT
	tty.sg_flags = flags;
	ioctl(0, TIOCSETP, &tty);
#else
	tty.c_lflag = lflags;
	tty.c_cc[VMIN] = omin;
	ioctl(0, TCSETA, &tty);
#endif
}

graphics()
{
	putchar(ESC);
}

alpha(with_print)
int with_print;
{
	if(with_print == YES) {
		set_cur_col(128);
		alpha_curs(128);
	}
	putchar(SOH);
}

savecap()
{
	user_sub(REM_CAP);
}

oldcap()
{
	user_sub(RESTORE_CAP);
}

char *cursor()
{
	static char buf[6];
	int i;

	alpha(NO);
	putchar(7);
	graphics();
	echo_off();
	putchar(SUB);
	fflush(stdout); i = read(0, buf, 6);
	if(i == 1)
		read(0, &buf[1], 5);
	restore();
	putchar(US);
	graphics();
	if(i < 1)
		return(0);
	return(buf);
}

char read_cursor(x, y, with_curs)
int *x, *y, with_curs;
{
	char *p, c[6];
	int i;

	if(with_curs == YES)
		if(p = cursor()) {
			*x = ((p[1]<<4)&0760) | ((p[2]>>1)&017);
			*y = ((p[3]<<4)&0760) | ((p[4]>>1)&017);
			return(*p);
		} else
			return(0);
	else {
		echo_off();
		putchar(RCP);
		putchar(SCR);
		alpha(NO);
		fflush(stdout); i = read(0, c, 6);
		restore();
		graphics();
		if(i == 6) {
			while(i--)
				c[i] -= '0';
			*x = 256*(c[0]/4) + 16*c[1] + c[2];
			*y = 256*(c[0]%4) + 16*c[3] + c[4];
			return(1);
		}
		return(0);
	}
}

read_joystick(x, y)
int *x, *y;
{
	char c[6];
	int i;

	echo_off();
	putchar(RJP);
	putchar(SCR);
	fflush(stdout); i = read(0, c, 6);
	restore();
	graphics();
	if(i == 6) {
		while(i--)
			c[i] -= '0';
		*x = 256*(c[0]/4) + 16*c[1] + c[2];
		*y = 256*(c[0]%4) + 16*c[3] + c[4];
		return(1);
	}
	return(0);
}

char read_pixel(color, with_curs)
int *color, with_curs;
{
	char *p, c[3];
	int i;

	if(with_curs == YES && (p = cursor()) == 0)
		return(0);
	echo_off();
	putchar(RPX);
	putchar(SCR);
	alpha(NO);
	fflush(stdout); i = read(0, c, 3);
	restore();
	graphics();
	if(i < 3)
		return(0);
	*color = 16 * (c[0]-'0') + (c[1]-'0');
	if(with_curs == YES)
		return(*p);
	else
		return(1);
}

byte(i)  /* 'modified hex' format */
int i;
{
	putchar('0' + ((i>>4) & 017));
	putchar('0' + (i & 017));
}

xy20(x,y)
int x, y;
{
	putchar('0' + (((x >> 6) & 014) + ((y >> 8) & 3)));
	byte(x); byte(y);
}

/*
 * Each of the remaining routines in this
 * file implements one AED graphics command
 * and should be called in graphics mode.
 */

move(x,y)
int x, y;
{
	putchar(MOV);
	xy20(x,y);
}

vector(x,y)
int x, y;
{
	putchar(DVA);
	xy20(x,y);
}

set_cur_col(color)
int color;
{
	putchar(SEC);
	byte(color);
}

background(color)
int color;
{
	putchar(SBC);
	byte(color);
}

draw_rect(x,y)
int x, y;
{
	putchar(DFR);
	xy20(x,y);
}

set_color(color, rgb)
int color, *rgb;
{
	putchar(SCT);
	byte(color); byte(1);
	byte(*rgb++); byte(*rgb++); byte(*rgb++);
}

draw_circle(radius)
int radius;
{
	putchar(DCL);
	byte(radius);
}

fill()
{
	putchar(IFL);
}

write_pixel(color)
int color;
{
	putchar(WPX);
	byte(color);
}

move_rel(dx, dy)
int dx, dy;
{
	putchar(MVR);
	byte(dx); byte(dy);
}

vec_rel(dx, dy)
int dx, dy;
{
	putchar(DVR);
	byte(dx); byte(dy);
}

origin(x,y)
int x, y;
{
	putchar(BSO);
	byte(x/256); byte(x%256);
	byte(y/256); byte(y%256);
}

zoom(xmag, ymag)
int xmag, ymag;
{
	putchar(SZR);
	byte(xmag); byte(ymag);
}

define_aoi(x,y)
int x, y;
{
	putchar(DAI);
	xy20(x,y);
}

write_aoi(array)
int *array;
{
	putchar(WHS);
	while(*array >= 0)
		putchar(*array++);
}

runs(length, color, size)
int *length, *color, size;
{
	int i;

	putchar(WHR);
	for(i = 0; i < size; i++) {
		byte(length[i]);
		byte(color[i]);
	}
	byte(0);
}

chain(direc)
int *direc;
{
	int i, n;

	putchar(WIP);
	n = 0;
	while(direc[n] != -1)
		n++;
	byte(n/256); byte(n%256);
	for(i = 0; i < n/2; i++)
		byte(8*direc[2*i] + direc[2*i+1]);
	if(n%2)
		byte(8*direc[n-1]);
}

set_blink(color, rgb, on, off)
int color, *rgb, on, off;
{
	putchar(SBL);
	byte(color);
	byte(*rgb++); byte(*rgb++); byte(*rgb);
	byte(on); byte(off);
}

user_sub(loc)
{
	putchar(JUS);
	byte(loc/256);
	byte(loc%256);
}

erase()
{
	putchar(FFD);
	graphics();
}

home()
{
	putchar(HOM);
}

r_mask(mask)
int mask;
{
	putchar(SRM);
	byte(mask);
	byte(255);
	byte(255);
	byte(255);
}

w_mask(mask)
int mask;
{
	putchar(SWM);
	byte(mask);
}

alpha_curs(color)
int color;
{
	putchar(SAC);
	byte(color);
}
