#include <stdio.h>
#include <ctype.h>
#include "color.h"

#define MISSING		-1234567

struct HUE {
	char hlabel[10];
	int hvalue;
} hue_names[] =
{
	"blue",		0,
	"magenta",	60,
	"red",		120,
	"orange",	150,
	"yellow",	180,
	"green",	240,
	"cyan",		300,
	"",		-1
};

static int l_default, s_default;

char *getint(p, val)
char *p;
int *val;
{
	*val = 0;
	while(isdigit(*p))
		*val = *val * 10 + *p++ - '0';
	return(p);
}

char *getstr(p, val)
char *p;
int *val;
{
	struct HUE *h;
	char buf[20], *bp;

	bp = buf;
	while(islower(*p))
		*bp++ = *p++;
	*bp = 0;
	*val = -1;
	for(h = hue_names; h->hvalue >= 0; h++)
		if(strcmp(buf, h->hlabel) == 0) {
			*val = h->hvalue;
			break;
		}
	if(*val == -1 && strcmp(buf, "gray") == 0) {
		*val = 0;
		s_default = 0;
	} else if(strcmp(buf, "white") == 0) {
		*val = 0;
		l_default = 100;
	} else if(strcmp(buf, "black") == 0) {
		*val = 0;
		l_default = 0;
	}
	return(p);
}

char *delim(p)
char *p;
{
	while(isspace(*p))
		p++;
	if(*p == ',') {
		p++;
		while(isspace(*p))
			p++;
	}
	return(p);
}

char *getrange(p, from, to, by, isrange)
char *p;
int *from, *to, *by, *isrange;
{
	*by = 1; *from = MISSING;
	if(*p == ',' || *p == 0)
		return(delim(p));
	if(isdigit(*p))
		p = getint(p, from);
	else
		p = getstr(p, from);
	if(*p == '-' || *p == ':') {
		if(isdigit(*++p))
			p = getint(p, to);
		else
			p = getstr(p, to);
		if(*p == '-' || *p == ':')
			p = getint(++p, by);
		*isrange = 1;
	} else {
		*to = *from;
		*isrange = 0;
	}
	return(delim(p));
}

process(str, with_fill)
char *str;
int with_fill;
{
	int nfrom, nto, nby, nisrange, from[3], to[3], by[3], isrange[3], range[3];
	int count, sign, index, i, j;

	if(*str == 0)
		return(-1);
	s_default = 100; l_default = 50;
	while(isspace(*str))
		str++;
	str = getrange(str, &nfrom, &nto, &nby, &nisrange);
	for(i = 0; i < 3; i++)
		str = getrange(str, &from[i], &to[i], &by[i], &isrange[i]);
	if(nfrom == MISSING)
		nfrom = nto = 0;
	if(from[H] == MISSING) {
		from[H] = 0;
		to[H] = 360;
	}
	if(from[H] == to[H] && isrange[H])
		to[H] += 360;
	if(from[L] == MISSING)
		if(s_default == 0) {
			from[L] = 0;
			to[L] = 100;
		} else
			from[L] = to[L] = l_default;
	if(from[S] == MISSING)
		from[S] = to[S] = s_default;
	if(!betw(0, nfrom, 255) || !betw(0, nto, 255) ||
	   !betw(0, from[L], 100) || !betw(0, to[L], 100) ||
	   !betw(0, from[S], 100) || !betw(0, to[S], 100))
		return(0);
	count = nto - nfrom;
	if(count == 0) {
		for(i = 0; i < 3; i++)
			Colors[nto].HLS[i] = from[i];
		Colors[nto].known = MIXED;
		if(with_fill == YES)
			set_table(nto, Colors[nto].HLS);
		return(1);
	}
	sign = 1;
	if(count < 0) {
		sign = -1;
		count = -count;
	}
	count /= nby;
	for(i = 0; i < 3; i++)
		range[i] = to[i] - from[i];
	for(j = 0; j <= count; j++) {
		index = nfrom + sign*j*nby;
		for(i = 0; i < 3; i++)
			Colors[index].HLS[i] = from[i] + j*range[i]/count;
		Colors[index].known = FORMULA;
		if(with_fill == YES)
			set_table(index, Colors[index].HLS);
	}
	return(count + 1);
}
