SUPPORT(zpolyz,		fill a polygon on AED512)
subroutine zpolyz(x1,y1,n)
real x1(n),y1(n)
include(aed512.m)
INCLUDE(graphics)
logical begin,clippd
real rx(2),ry(2),rrx(2),rry(2),xclip,yclip
integer bcol,col,lty,xfirst,yfirst,flood(5)
data flood/1,ESC,66,0,0/	#  out of graphics ESC B color number
if(n<3){
	call zflshz
	call zerrpz("zpolyz",TSTRING(Needs at least 3 points))
	return
	}
QUERY( col(col), lty(lty) )
if(col>0 & col<128) bcol=iabs(col)+128; else bcol=col
SPECIFY( lty(1), col(bcol) )
for(iter=1; iter<=2; iter=iter+1){	# first outline & flood, then remove outline
	begin = TRUE; clippd=FALSE
	rx(2) = x1(1)*am(37)+am(36)
	ry(2) = y1(1)*am(39)+am(38)
	do i = 2,n {
		rx(1) = rx(2)
		ry(1) = ry(2)
		rx(2) = x1(i)*am(37)+am(36)
		ry(2) = y1(i)*am(39)+am(38)
		call lclipz(rx,ry,am(32),am(34),rrx,rry,jint)
		if (begin && jint==0) {	# first point not clipped
			irx = rrx(1)+.5
			iry = rry(1)+.5
			call intior(irx,iry,1)
			call zseekz(irx,iry)
			begin = FALSE
			xfirst=irx; yfirst=iry
			}
		if (jint!=0) {	# clipped segment
			clippd = TRUE; xclip=x1(i); yclip=y1(i)
			if (jint<0) next 	# skip if entirely out of bounds
			irx = rrx(1)+.5
			iry = rry(1)+.5
			if (begin) {
				call intior(irx,iry,1)
				call zseekz(irx,iry)
				begin = FALSE
				xfirst=irx; yfirst=iry
				}
			else {
				call intior(irx,iry,2)
				call zlinez(irx,iry)
				}
			}
		irx = rrx(2)+.5
		iry = rry(2)+.5
		call intior(irx,iry,2)
		call zlinez(irx,iry)
		}
	if(!begin) call zlinez(xfirst,yfirst)	# close the polygon
	if(!begin && iter==1){
		call intior(xfirst,yfirst,2)
		call intior(irx,iry,3)
		SPECIFY( col(col) )
		call zseekz(irx,iry)	# seek to interior
		flood(4)=48+bcol/16
		flood(5)=48+mod(bcol,16)
		call zoutrz(flood,5)	# flood to boundary
		if(col>0 & col<128) SPECIFY( col(col+256) )  # erases top plane
		}
	}
SPECIFY( col(col), lty(lty) )
call zflshz
if(clippd) call zobdsz(TSTRING(Polygon),xclip,yclip)
return
end
