FUNCTION axes (
	main	/CHAR,OPTIONAL/
	sub	/CHAR,OPTIONAL/
	xlab	/CHAR,OPTIONAL/
	ylab	/CHAR,OPTIONAL/
	axes	/LGL,1,streq(TEXT(fname),TSTRING(`axes'))/
	PAR
	&
	)
STATIC( logical streq )
STATIC( real m1,m2,m3,m4,r,cex,pos )
STATIC( integer err )
STATIC( real xti,xla,xli; CHARACTER(itype,1) )
QUERY( mar(m1,m2,m3,m4), mex(r), cex(cex), mgp(xti,xla), err(err) )
r=cex/r
if(!MISSING(main)){
	SPECIFY( cex(1.5*cex) )
	pos=amin1(m3-1.5*r,2.*r)
	if(pos>0.)call mtextz(TOP,pos,TEXT(main))
	else if(islenz(TEXT(main))>0 & err>=0) WARNING(No room for main title)
	SPECIFY( cex(cex) )
	}
if(!MISSING(sub)) 
	if(xti+r<=m1-r)call mtextz(BOTTOM,xti+r,TEXT(sub))
	else if(islenz(TEXT(sub))>0 & err>=0) WARNING(No room for subtitle)
if(!MISSING(xlab)) 
	if(xti<=m1-r)call mtextz(BOTTOM,xti,TEXT(xlab))
	else if(islenz(TEXT(xlab))>0 & err>=0) WARNING(No room for xlab)
if(!MISSING(ylab)) 
	if(xti<=m2-r)call mtextz(LEFT,xti,TEXT(ylab))
	else if(islenz(TEXT(ylab))>0 & err>=0) WARNING(No room for ylab)
if(axes){
	QUERY( xaxt(itype) )
	if(xla>m1-r & err>=0)WARNING(No room for X-axis)
	else if(itype=="s") call saxisz(BOTTOM,TRUE,TRUE)
	else if(itype=="t") call taxisz(BOTTOM,TRUE,TRUE)
	else if(itype=="l") call laxisz(BOTTOM,TRUE,TRUE)
	QUERY( yaxt(itype) )
	if(xla>m2-r & err>=0)WARNING(No room for Y-axis)
	else if(itype=="s") call saxisz(LEFT,TRUE,TRUE)
	else if(itype=="t") call taxisz(LEFT,TRUE,TRUE)
	else if(itype=="l") call laxisz(LEFT,TRUE,TRUE)
	call boxz
	}
NOPRINT
RETURN(FILTER)
END
