ROUTINE(chpeel,		convex hull peels)
subroutine chpeel(x,y,n,mxpeel,depth,hull,count,ncount,
	indx,theta,order,nxt,prev,tol)
real x(n),y(n),theta(n),tol
integer n,mxpeel,depth(n),hull(n),count(1),indx(n),order(n),nxt(n),prev(n)
# count should be n/3+1 long (all hulls are nested triangles)

logical fail
integer i,j,k,nleft,nout,peel,filld

for(i=1; i<=n; i=i+1) indx(i)=i	# point number
nleft=n; nout=0

for(peel=1; peel<=mxpeel && nleft>2; peel=peel+1){
	call chull(x,y,nleft,theta,order,nxt,prev,TRUE,tol,nthis,fail)
	if(fail) break	# all points colinear
	count(peel)=nthis
	for(i=1; i<=nthis; i=i+1){
		nout=nout+1
		j=prev(i); k=indx(j)
		hull(nout)=k
		depth(k)=peel	# depth of the jth point
		indx(j)=0	# mark for removal next iteration
		}
	filld=0
	for(i=1; i<=nleft; i=i+1)	# remove points on prev hull
		if(indx(i)!=0){
			filld=filld+1
			if(i!=filld){ x(filld)=x(i); y(filld)=y(i); indx(filld)=indx(i) }
			}
	if(filld!=nleft-nthis) FATAL(Assertion failure)
	nleft=nleft-nthis
	}

if(nleft>0) count(peel)=nleft	# mop up any remaining points
else peel=peel-1
for(i=1; i<=nleft; i=i+1){
	nout=nout+1
	j=indx(i)
	hull(nout)=j
	depth(j)=peel
	}
ncount=peel

return
end
