FUNCTION code(
	x	/ANY,VECTOR,NAOK/
	levels	/ANY,VECTOR,OPTIONAL,NAOK/
	labels	/ANY,VECTOR,OPTIONAL/
	)
# given vector of data with discrete values, create a category structure
# with levels as given or equal to the unique values in x
INCLUDE(search)
STATIC( POINTER tbl, p, indx )
STATIC( integer i, n, mode, tlen, status, i1,i2,i3; logical nolevs )

if(MODE(x)==LGL) COERCE(x/INT/)
nolevs=MISSING(levels)
if(nolevs){ #use the unique, sorted values in the data
	ALLOCATE(levels/LIKE(x),ANY,NAOK/)
	NAOUT(`levels')	# omit NAs
	if(LENGTH(levels)==0)FATAL(Data vector contained only NAs)
	call sortv(PDATA(levels))
	}
else {
	if(!MISSING(labels))
		if(LENGTH(levels)!=LENGTH(labels))
			FATAL(Lengths of levels and labels must match)
	COERCE(levels/MODECALC(MODE(x)),NAOK/)
	}
call thash(MODE(levels),LENGTH(levels),VALUE(levels),nuniq,tbl,tlen,indx,nolevs)
# get hash table, no. unique entries
# note that on return VALUE(levels) points to unique level

if(!nolevs & nuniq<LENGTH(levels))FATAL(levels must be unique if given)
else LENGTH(levels)=nuniq #return only unique values

n=LENGTH(x); mode=MODE(x); p=VALUE(x)
STRUCTURE(Index/INT,n/)
for(i=0; i<n; i=i+1) { # hash the values
	if(nolevs&NAVALUE(p+i,mode)){ NASET(Index[i+1]); next}
	call vhash(p+i,mode,is(tbl),tlen,FALSE,ihash,status)
	if(status==NEW_ITEM)NASET(Index[i+1])
	else Index[i+1]=is(indx+ihash-1) #get which level it was
	}

if(MISSING(labels))ALLOCATE(labels/LIKE(levels)/)
if(MODE(labels)!=CHAR) { #encode them
	p=VALUE(labels)
	ALLOCATE(labels/CHAR,nuniq/) #allocate new vector
	for(i=0; i<nuniq; i=i+1) {
		ENCODE(V(mode,p+i,0))
		labels[i+1]=istrng(BUFFER,BUFPOS) #make the string
		CLEAR #print buffer
		}
	}
RETURN(Label=labels,Data=Index)
END
