FUNCTION cut( x/REAL,NAOK/, breaks/REAL/, labels/CHAR,VECTOR,OPTIONAL/ )

if(LENGTH(breaks)==1) { #create equal width break points
	nlevs=breaks
	STRUCTURE( breaks/REAL,nlevs+1/ )
	call narang(x,LENGTH(x),xmin,xmax)
	delta=1.01*(xmax-xmin)/nlevs; if(delta==0.) delta=1.	# guard against all pts equal
	for(i=0; i<=nlevs; i=i+1) breaks[i+1]=xmin+(float(i)-.01)*delta	# makes first break less than xmin
	if(MISSING(labels)) {
		STRUCTURE(labels/CHAR,nlevs/)
		for(i=1; i<=nlevs; i=i+1) {
			ENCODE("Range",I(i))
			labels[i]=istrng(BUFFER,BUFPOS)
			CLEAR
			}
		}
	else if(LENGTH(labels)!=nlevs)
		FATAL(Number of labels must equal number of intervals)
	}
else {
	call sort(breaks,LENGTH(breaks))
	if(MISSING(labels)) {
		STRUCTURE(labels/CHAR,LENGTH(breaks)-1/)
		for(i=1; i<LENGTH(breaks); i=i+1){
			ENCODE(R(breaks[i],0),"+ thru",R(breaks[i+1]))
			labels[i]=istrng(BUFFER,BUFPOS)
			CLEAR
			}
		}
	if(LENGTH(labels)!=LENGTH(breaks)-1)
		FATAL(Number of labels must be 1 less than number of break points)
	}

STRUCTURE( Index/INT,LENGTH(x)/)

for(i=1; i<=LENGTH(x); i=i+1) {
	if(NA(x[i])) NASET(Index[i])
	else {
		for(ii=1;ii<=LENGTH(breaks); ii=ii+1)
			if(x[i]<=breaks[ii]) break
		if(ii==1|ii>LENGTH(breaks)) NASET(Index[i])
		else Index[i]=ii-1
		}
	}

RETURN(Label=labels,Data=Index)
END
