FUNCTION density(
	x	/REAL/
	n	/INT,1,50/
	window	/CHAR,1,STRING(g)/
	width	/REAL,1/
	from	/REAL,1/
	to	/REAL,1/
	cut	/REAL,1,.5/
	)
STRUCTURE(
	y	/REAL,n/
	xout	/REAL,n/
	)

STATIC( real delta,xhigh,xlow )

call sort(x,LENGTH(x))
xlow=x[1]; xhigh=x[LENGTH(x)]

CTABLE(windws,rectangular,triangular,cosine,gaussian) #window values
iwindo=match(window,windws)
if(iwindo<0)FATAL(Invalid window type)

if(MISSING(cut) & iwindo==4) cut=.75

if(MISSING(width)){
	call hhdonz(x,LENGTH(x),nbar,nxt)
	width=(xhigh-xlow)/float(nbar)*.5
	}

if(MISSING(from)) from=xlow-width*cut
if(MISSING(to))  to=xhigh+width*cut

CHECK(to>from,FATAL(Invalid from/to values))

delta=(to-from)/float(max0(n-1,1))
for(i=1; i<n; i=i+1) xout[i]=from+float(i-1)*delta
xout[n]=to

call fitden(x,LENGTH(x),iwindo,width,from,to,n,y)

RETURN(x=xout,y)
END
