ROUTINE(face,	  plot a chernoff face)
subroutine face(w,ind,wl,fill,x,y,xp,yp,ol)
logical fill
real w(15),wl(2,15),z(15); integer ind(15)
real xc(20),yc(20),x(52),y(52),xp(52),yp(52)
real ol(2,15)
integer pmax
logical ok(15),eye,brow,oktemp
dimension xc1(8),yc1(8)
data pmax/15/,nvert/20/,nvert1/8/
data pi/3.1415926/
data xc,yc,xc1,yc1 _
/   0.10000000E1,0.94581724,0.78914051,0.54694818,0.24548552,-0.82579314E-01,-0.40169538,-0.67728155,
  -0.87947372,-0.98636130,-0.98636131,-0.87947379,-0.67728164,-0.40169552,-0.82579392E-01,0.24548538,
   0.54694806,0.78914043,0.94581720,0.10000000E1,0.,0.32469946,0.61421270,0.83716647,
   0.96940025,0.99658449,0.91577335,0.73572392,0.47594744,0.16459465,-0.16459453,-0.47594733,
  -0.73572385,-0.91577328,-0.99658449,-0.96940029,-0.83716654,-0.61421280,-0.32469958,0.,
   0.10000000E1,0.62348981,-0.22252091,-0.90096884,-0.90096889,-0.22252101,0.62348970,0.10000000E1,
   0.,0.78183147,0.97492792,0.43388380,-0.43388369,-0.97492789,-0.78183156,0./
#
#
#  scale the user coordinates into face space coordinates
#
do i = 1,pmax {
	j = ind(i); oktemp= (fill | j!=0) && !NA(w(j)); ok(i)=oktemp
	if (j!=0 && ok(i) & wl(1,j)!=wl(2,j)) z(i) = (w(j)-wl(1,j))*(ol(1,i)-ol(2,i))/(wl(1,j)-wl(2,j))+ol(1,i)
	else z(i) = (ol(1,i)+ol(2,i))/2.0
	}
#
#  construct two unit circles with different coarsenesses
#
#if (!nfirst) {
#	do i = 1,nvert {
#		a = (i-1)*2*pi/(nvert-1)
#		xc(i) = cos(a)
#		yc(i) = sin(a)
#		}
#	do i = 1,nvert1 {
#		a = (i-1)*2*pi/(nvert1-1)
#		xc1(i) = cos(a)
#		yc1(i) = sin(a)
#		}
#	nfirst = .true.
#	}
#
#  outline of face
#
if(ok(1) & ok(2) ) {
	ef = 1.0+abs(z(2))
	if (z(2)<0.0)
		ef = 1.0/ef
	bf = sqrt(z(1)/ef)
	af = bf*ef
	do i = 1,nvert {
		xp(i) = af*xc(i)
		yp(i) = bf*yc(i)
		}
	call linesz(xp,yp,nvert)
	}
#
#  nose
#
if(ok(3)) {
	ynose = bf*z(3)/2.0
	xp(1) = 0.
	xp(2) = 0.
	yp(1) = ynose
	yp(2) = -ynose
	call linesz(xp,yp,2)
	}
#
#  mouth
#
if(ok(4) & ok(5) & ok(6)) {
	nteeth = 10
	a = af*z(6)/2.0
	b = 2.0/(nteeth-1)
	do i = 1,nteeth {
		xx = b*(i-1.0)-1.0
		yy = z(5)*xx**2
		xp(i) = a*xx
		yp(i) = (a*yy-bf+z(4)*(bf-ynose))
		}
	call linesz(xp,yp,nteeth)
	}
#
#  right eye, centered
#
ee = 1.0+abs(z(10))
if (z(10)<0.0)
	ee = 1.0/ee
ae = z(11)*af/2.0
be = ae/ee
xeye = z(8)*af
yeye = z(7)*(bf-ynose)+ynose
do i = 1,nvert {
	x(i) = ae*xc(i)
	y(i) = be*yc(i)
	}
#
#  right pupil
#
pupsc = 0.02
xx = z(12)*ae
do i = 1,nvert1 {
	x(nvert+i) = xc1(i)*pupsc-xx
	y(nvert+i) = yc1(i)*pupsc
	}
#
#  rotate right eye and pupil
#
theta = pi*z(9)/4.0
costh = cos(theta)
sinth = sin(theta)
nx = nvert+nvert1
do i = 1,nx {
	xx = x(i)
	yy = y(i)
	x(i) = xx*costh-yy*sinth
	y(i) = xx*sinth+yy*costh
	}
#
#  right eyebrow
#
theta = pi*z(14)/4.0
costh = cos(theta)
sinth = sin(theta)
xx = z(15)*af/2.0
yy = z(13)*(bf-yeye-be)+be
x(nx+1) = -xx*costh
y(nx+1) = -xx*sinth+yy
x(nx+2) = xx*costh
y(nx+2) = xx*sinth+yy
#
#  position and plot eyes, pupils, eyebrows, first right then left
eye=ok(7) & ok(8) & ok(9) & ok(10) & ok(11) & ok(12)
brow=ok(13) & ok(14) & ok(15)
#
nx2 = nx+2
do i = 1,nx2
	yp(i) = (y(i)+yeye)
do lr = 1,2 {
	xsign = 3-2*lr
	do i = 1,nx2
		xp(i) = xsign*(x(i)+xeye)
	if(eye) {
		call linesz(xp,yp,nvert)
		call linesz(xp(nvert+1),yp(nvert+1),nvert1)
		}
	if(brow)call linesz(xp(nx+1),yp(nx+1),2)
	}
return
end



