FUNCTION hist(
	x		/REAL,NAOK/
	nclass		/INT,1/
	breaks		/REAL,OPTIONAL/
	scale		/LGL,1,FALSE/
	plot		/LGL,1,TRUE/
	xlab=		/CHAR,1,DATANAME(x)/
	&
	)

NAOUT(`x')
if(LENGTH(x)==0) FATAL(Input vector was all NAs)
if(MISSING(breaks)){
	if(MISSING(nclass))call hhdonz(x,LENGTH(x),nclass,kd)
	else if(nclass>=1) nclass=nclass+1   #number of breaks (nclass+1)
	else FATAL(Number of classes <1)
	ALLOCATE(breaks/REAL,2*nclass/)
	call hhbrkz(x,LENGTH(x),nclass,LENGTH(breaks),breaks)
	}

STRUCTURE(counts/REAL,LENGTH(breaks)-1/, histo/LGL,1,TRUE/ )
call hhcntz(x,LENGTH(x),LENGTH(breaks),breaks,counts,scale)

if(plot)CHAIN(barplot,height=counts,width=breaks,histo,xlab,FILTER)
else RETURN(breaks,counts)
END
