FUNCTION identify(&)
STRUCTURE(x/REAL/,y/REAL/)
PLOTARGS(NAOK)
ARG(
	labels	/ANY,OPTIONAL/
	n	/INT,1,LENGTH(x)/
	plot	/LGL,1,TRUE/
	atpen	/LGL,1,TRUE/
	offset	/REAL,1,.5/
	PAR
	)

STATIC( real ux,uy,dx,dy,adj,dist,d2,xin,yin,eps )
STATIC( integer i,j,nin,indx )
STATIC( logical xpd; CHARACTER(itype,1) )

CHECK(n>0,FATAL(n must be >0))
nx=LENGTH(x)
if(!MISSING(labels)){
	if(LENGTH(labels)!=nx) FATAL(label length wrong)
	if(MODE(labels)==LGL) COERCE(labels/INT/)
	}
STRUCTURE( subscr /INT,n/ )
CHECK(nx==LENGTH(y),FATAL(X and Y must match))
QUERY( axt(1,itype) ); if(itype=="l")call logtrn(x,nx)
QUERY( axt(2,itype) ); if(itype=="l")call logtrn(y,nx)

QUERY( uin(ux,uy), cxy(dx,dy), adj(adj), xpd(xpd) )
eps=dx*.25; dx=dx*offset
SPECIFY( xpd(TRUE) )
for(i=1; i<=n; i=i+1){
	call zrdpnz(xin,yin,nin,1)
	if(nin<1) break
	dist=1e10
	for(j=1; j<=nx; j=j+1){
		if(NA(x[j])|NA(y[j]))next
		d2=((x[j]-xin)*ux)**2+((y[j]-yin)*uy)**2
		if(d2 < dist){
			dist=d2
			indx=j
			}
		}
	if(dist>.5**2){
		WARNING(No point within .5 inch, try again)
		i=i-1
		next
		}
	subscr[i]=indx
	if(plot){
		side=xin-x[indx]+eps
		dx2=sign(dx,side)
		if(side>0.)SPECIFY( adj(0.) )
		else SPECIFY( adj(1.) )
		if(atpen) {xx=xin+dx2; yy=yin}
		else { xx=x[indx]+dx2; yy=y[indx] }
		if(MISSING(labels))call intz(xx,yy,indx)
		else  SWITCH MODE(labels){
			case CHAR: call textz(xx,yy,TEXT(labels[indx]))
			case INT: call intz(xx,yy,labels[indx])
			case REAL: call realz(xx,yy,labels[indx])
			}
		}
	}
SPECIFY( adj(adj), xpd(xpd) )
if(i>1){
	LENGTH(subscr)=i-1
	RETURN(subscr)
	}
END
