# convergence types
define(`DELTA_X', 1)
define(`SMALL_GRAD', 2)
define(`MAX_EVAL', 3)

define(`Gdx', `ifelse($1,,wc,wc($*))')
define(`dg', `ifelse($1,,newt,newt($*))')
define(`cauchy', `ifelse($1,,wb,wb($*))')
define(`scr', `ifelse($1,,wb,wb($*))')
define(`FCALC', 1)
define(`GCALC', 2)

subroutine optlp(n, xnew, fnew, gnew, f, radsq, xtol, gtol, gsq,
		newtsq, gGg, d, x, g, dx, wb, wc, newt, diag, var,
		hess, maxev, nf, ng, halt, which)
integer n, maxev, halt, i, nf, ng, which
real xnew(n), f, fnew, gnew(n), radsq, xtol, gtol, x(n), g(n), dx(n), wb(n), wc(n),
     newt(n), diag(n), var(n,n), hess(1), gsq, newtsq, gGg, d, e, c, theta, gdx, dxGdx, prod

if(which == FCALC) goto FCALC
if(which == GCALC) goto GCALC

while(xtol*dotv(x,n,x) < radsq & gsq > gtol & nf < maxev) {
	do i = 1, n
		wc(i) = -g(i)
	call solve(hess, n, diag, newt, wc)
	newtsq = dotv(newt, n, newt)
	gGg = Gdot(g, hess, n, diag, wb)
	d = 0.2 - 0.8 * (gsq**2 / (dotv(newt, n, g) * gGg))
	radsq = 4.0 * radsq
	repeat {   # until function value decreases
		radsq = 0.25 * radsq
		if(newtsq < radsq)  # newton step is small - take it
			call rcopy(newt, dx, n)
		else if(d*d*newtsq <= radsq) {  # take truncated newton step
			e = sqrt(radsq/newtsq)
			do i = 1, n
				dx(i) = e * newt(i)
		} else if(gGg*gGg*radsq <= gsq**3) {  # Cauchy step is large - use truncated version
			e = -sqrt(radsq/gsq)
			do i = 1, n
				dx(i) = e * g(i)
		} else {  # take double dogleg step
			e = -gsq / gGg
			do i = 1, n {
				cauchy(i) = e * g(i)  # Cauchy step
				wc(i) = d * newt(i) - cauchy(i)
			}
			prod = dotv(cauchy, n, wc)
			c = radsq - e**2 * gsq  # positive in this 'else'
			theta = c / (prod + sqrt(prod**2 + c * dotv(wc,n,wc)))
			do i = 1, n
				dx(i) = cauchy(i) + theta * wc(i)
		}
		do i = 1, n
			xnew(i) = x(i) + dx(i)
		which = FCALC
		return
FCALC		nf = nf + 1
	} until(fnew < f)
	which = GCALC
	return
GCALC	ng = ng + 1
	dxGdx = Gdot(dx, hess, n, diag, Gdx)
	do i = 1, n {
		dg(i) = gnew(i) - g(i)
		wb(i) = dg(i) - Gdx(i)
	}
	gdx = dotv(g, n, dx)
	if(fnew - f > 0.1 * (gdx + 0.5*dxGdx))
		radsq = 0.25 * dotv(dx, n, dx)
	else if(dotv(wb, n, wb) < 0.25*gsq | gdx > 2.0*dotv(gnew, n, dx))
		radsq = 4.0 * dotv(dx, n, dx)
	else
		radsq = dotv(dx, n, dx)
# compute BFGS update
	call update(hess, n, diag, 1.0/dotv(dg,n,dx), dg, scr)
	call update(hess, n, diag, -1.0/dxGdx, Gdx, scr)
	call rcopy(xnew, x, n)
	f = fnew
	call rcopy(gnew, g, n)
	gsq = dotv(g, n, g)
}
if(gsq < gtol)
	halt = SMALL_GRAD
else if(nfcall >= maxev)
	halt = MAX_EVAL
else
	halt = DELTA_X
call varmak(hess, n, diag, var, scr)
return
end



subroutine update(L, n, D, s, z, p)

# compute the Cholesky factorization of LDL' + szz'; the
# new factors are stored in L and D, and the new LDL' is
# ensured to be positive definite (note: z gets overwritten)

# Reference: P. E. Gill et. al., "Methods for Modifying Matrix
# Factorizations", Mathematics of Computation, 1974, vol. 28,
# pages 505-535 (especially Algorithm C2, page 520)

integer n, i, j, k
real L(1), D(n), s, z(n), p(n)
real sum, sigma, alpha, pi, q, theta, rho, rhosq, beta

alpha = s
call rcopy(z, p, n)
sum = 0.0
k = 1
do i = 1, n {
	pi = p(i)
	do j = i+1, n {
		p(j) = p(j) - pi * L(k)
		k = k + 1
	}
	sum = sum + pi**2 / D(i)
}
sigma = alpha * sum
if(sigma <= -1.0)
	sigma = -sigma  # ensure positive definiteness
sigma = alpha / (1.0 + sqrt(1.0 + sigma))
k = 1
do i = 1, n {
	pi = p(i)
	q = pi**2 / D(i)
	theta = 1.0 + sigma * q
	sum = amax1(sum - q, 0.0)
	rhosq = theta**2 + sigma**2 * q * sum
	rho = sign(sqrt(rhosq), theta)
	D(i) = rhosq * D(i)
	beta = alpha * pi / D(i)
	alpha = alpha / rhosq
	sigma = sigma * (1.0 + rho) / (rho * (theta + rho))
	do j = i+1, n {
		z(j) = z(j) - pi * L(k)
		L(k) = L(k) + beta * z(j)
		k = k + 1
	}
}
return
end



subroutine solve(L, n, D, x, b)

# solve LDL'x = b for x

integer n, i, j, k
real L(1), D(n), x(n), b(n), sum

# forward substitution
call rcopy(b, x, n)
k = 1
do i = 1, n {
	sum = x(i)
	x(i) = sum / D(i)
	do j = i+1, n {
		x(j) = x(j) - sum * L(k)
		k = k + 1
	}
}
# back substitution
k = n*(n-1)/2
do i = n-1, 1, -1 {
	sum = x(i)
	do j = i+1, n {
		sum = sum - L(k) * x(j)
		k = k + 1
	}
	x(i) = sum
	k = k - 2*(n-i) - 1
}
return
end



real function Gdot(a, L, n, D, b)

# b <- LDL'a and Gdot <- a'LDL'a

integer n, i, j, k1, k2
real a(n), L(1), D(n), b(n), sum

Gdot = 0.0
call rfill(0.0, b, n)
k1 = 1; k2 = 1;
do i = 1, n {
	sum = a(i)
	do j = i+1, n {
		sum = sum + L(k1) * a(j)
		k1 = k1 + 1
	}
	Gdot = Gdot + sum * sum * D(i)
	sum = sum * D(i)
	b(i) = b(i) + sum
	do j = i+1, n {
		b(j) = b(j) + l(k2) * sum
		k2 = k2 + 1
	}
}
return
end


subroutine varmak(L, n, D, var, scrach)

# var <- inverse of LDL'

integer n, i
real L(1), D(n), var(n,n), scrach(n)

call rfill(0.0, scrach, n)
do i = 1, n {
	if(i > 1)
		scrach(i-1) = 0.0
	scrach(i) = 1.0
	call solve(L, n, D, var(1,i), scrach)
}
return
end
