FUNCTION plotfit(fit/STR/,&)
STRUCTURE(
	row	/REAL,FROM(fit),NAOK/
	col	/REAL,FROM(fit),NAOK/
	grand	/REAL,FROM(fit),NAFATAL/
	resid	/REAL,FROM(fit),NAOK/
	)
ARG(
	w	/REAL,1,0./
	c	/REAL,1,-1./
	rowlab	/CHAR,LENGTH(row)/
	collab	/CHAR,LENGTH(col)/
	grid	/LGL,1,TRUE/
	ylim=	/REAL,2/
	PAR
	&
	)
STATIC( logical xpd )
nr=LENGTH(row); nc=LENGTH(col); nline=nr+nc
if(c>=0.)nline=nline+nr*nc
STRUCTURE(xy/MATRIX,nline,4/)
if(MISSING(rowlab))
	for(i=1; i<=nr; i=i+1){
		ENCODE("Row",I(i)); rowlab[i]=istrng(BUFFER,BUFPOS); CLEAR
		}
if(MISSING(collab))
	for(i=1; i<=nc; i=i+1){
		ENCODE("Col",I(i)); collab[i]=istrng(BUFFER,BUFPOS); CLEAR
		}
call pltfit(row,nr,col,nc,grand,w,resid,nr,c,xy,nline,nl,ngrid)
if(MISSING(ylim))
	call rangev(xy[1,3],nl,ylim[1],ylim[2]); call rangec(xy[1,4],nl,ylim[1],ylim[2])
call rangev(xy[1,1],nl,x1,x2); call rangec(xy[1,2],nl,x1,x2)
eps=.01*(x2-x1); x1=x1-eps; x2=x2+eps

call beginz
QUERY( lab(nx,ny,ll) )
call stdaxz(2," ",ylim[1],ylim[2],ny,3)
QUERY( usr(,,y1,y2) )
SPECIFY( usr(x1,x2) )
QUERY( uin(ux,uy), pin(xi,yi), `col'(colr), lty(olty) )
if(ux>uy){ add=.5*(xi/uy-(x2-x1)); SPECIFY( usr(x1-add,x2+add) )}
else     { add=.5*(yi/ux-(y2-y1)); SPECIFY( usr(,,y1-add,y2+add) )}
nresid=nl-ngrid
if(nresid>0) SPECIFY( lty(2) )
if(grid && ngrid>0) call segmtz(xy[1,1],xy[1,3],xy[1,2],xy[1,4],ngrid)
if(nresid>0){	# plot residuals
	SPECIFY( lty(olty), `col'(2) )
	call segmtz(xy[ngrid+1,1],xy[ngrid+1,3],xy[ngrid+1,2],xy[ngrid+1,4],nresid)
	SPECIFY( `col'(colr) )
	}
QUERY( xpd(xpd), cxy(cx,cy) ); SPECIFY( xpd(TRUE) )
cy=cy*.5
k=0
for(i=1;i<=nc;i=i+1){
	if(NA(col[i]))next
	k=k+1
	j = mod(i-1,LENGTH(collab))+1
	if(islenz(TEXT(collab[j]))>0)
		if(xy[k,3]>xy[k,4])call textlz(xy[k,1]+cx,xy[k,3]+cy,TEXT(collab[j]))
		else               call textlz(xy[k,2]+cx,xy[k,4]+cy,TEXT(collab[j]))
	}
for(i=1;i<=nr;i=i+1){
	if(NA(row[i]))next
	k=k+1
	j=mod(i-1,LENGTH(rowlab))+1
	if(islenz(TEXT(rowlab[j]))>0)
		if(xy[k,1]>xy[k,2])call textlz(xy[k,1]+cx,xy[k,3]-cy,TEXT(rowlab[j]))
		else               call textlz(xy[k,2]+cx,xy[k,4]-cy,TEXT(rowlab[j]))
	}
SPECIFY( xpd(xpd) )
CHAIN(title,PAR,FILTER)
END
