FUNCTION regsum(z/STR/)
ARGSTR(z)
ARG(	r	/MATRIX/
	resid	/MATRIX/
	corth	/MATRIX/
	coef	/MATRIX/
	int	/LGL/
	sqrtw	/REAL,OPTIONAL/
	names	/CHAR,OPTIONAL/
	ynames	/CHAR,OPTIONAL/
	&
	)
STATIC( integer n,p,ny,namep,i,j; real var )
n=NROW(resid); p=NROW(r); ny=NCOL(resid)
STRUCTURE(
	cov	/MATRIX,p,p/
	cor	/MATRIX,p,p/
	diag	/REAL,p/
	stderr	/LIKE(coef)/
	t	/LIKE(coef)/
	rsq	/REAL,ny/
	rms	/REAL,ny/
	fval	/REAL,ny/
	df	/INT,2/
	xnames	/CHAR,p/
	)

namep = 1
if(int & (MISSING(names) | LENGTH(names)<p)) {
	xnames[namep]=istrng("Intercept",9)
	namep=2
	}
if(!MISSING(names)) {
	ncopy=min0(LENGTH(names),p-namep+1)
	call icopy(names,xnames[namep],ncopy)
	namep=namep+ncopy
	}
for(; namep<=p; namep=namep+1) {
	ENCODE("x",I(namep,0))
	xnames[namep]=istrng(BUFFER,BUFPOS)
	CLEAR
	}
if(!MISSING(sqrtw))
	for(i=1;i<=n;i=i+1)
		for(k=1;k<=ny;k=k+1)
			resid[i,k]=resid[i,k]*sqrtw[i]
call regcov(p,r,cov,cor,diag)
for(i=1;i<=ny;i=i+1)
	call regsum(n,p,corth[1,i],coef[1,i],stderr[1,i],t[1,i],diag,resid[1,i],rms[i],rsq[i],fval[i],int)
if(int)df[1]=p-1; else df[1]=p; df[2]=n-p	# degrees of freedom

if(MISSING(ynames)){
	STRUCTURE(ynames/CHAR,ny/)
	for(i=1; i<=ny; i=i+1){
		ENCODE("y",I(i,0))
		ynames[i]=istrng(BUFFER,BUFPOS)
		CLEAR
		}
	}
RETURN(names=xnames,ynames,&)
if(ny == 1) {
	STRUCTURE(table/MATRIX,p,3/)
	call rcopy(coef,table,p)
	call rcopy(stderr,table[1,2],p)
	call rcopy(t,table[1,3],p)
	RETURN(table,&)
}
RETURN(coef,stderr,t,cor,&)
if(ny == 1) {
	var=rms[1]**2
	for(i=1;i<=p;i=i+1)
		for(j=1;j<=p;j=j+1)
			cov[i,j]=cov[i,j]*var
	RETURN(cov,&)
	}
else
	RETURN(stdcov=cov,&)
RETURN(rsq,rms,fval,df)
END
