#dstclr			compute random no.s
subroutine dstclr(x,n,par1,npar1,par2,npar2,whichf,chain)
real x(1); integer n,whichf,npar1,npar2; logical chain; POINTER par1,par2
# x: vector of quantiles, quantiles to be overwritten into it
# n: length of x
# par1,par2: value pointers for parameters of dist., checked by dstpar
# npar1,npar2: length of parameter vectors
# whichf: code for distribution

INCLUDE(struct, dist)
external rnormk,uni,rstbl

PAR1=par1; PAR2=par2; NPAR1=npar1; NPAR2=npar2; NVALUES=n; WHICH=whichf #move values to common
chain=FALSE #flagged if interface routine should chain to quantile fn
switch(whichf) {
case NORM_DIST: call dstcr1(x,rnormk)
case UNIF_DIST: call dstcr1(x,uni)
case STABLE_DIST: call dstcr1(x,rstbl)
default: # use probability integral transform if needed
	WHICH=TRANSFORM
	call dstcr1(x,uni) #generate uniforms
	chain=TRUE
	}
return
end

#dstcr1		inner layer of dstclr, using common block, supplied function
subroutine dstcr1(x,prfun)
real x(1),prfun
external prfun

INCLUDE(stack, struct, dist)
integer i
i1=0; i2=0
for(i=1; i<=NVALUES; i=i+1) {
	switch(WHICH/10) { #switch on type of distr'n
	case UNIF_TYPE: x(i)=rs(PAR1+i1)+prfun(iseed)*(rs(PAR2+i2)-rs(PAR1+i1))
	case NORMAL_TYPE: x(i)=prfun(iseed)*rs(PAR2+i2)+rs(PAR1+i1) # location, scale family
	case TRANS_TYPE: x(i)=prfun(iseed)
	default: x(i)=prfun(iseed,rs(PAR1+i1),rs(PAR2+i2)) # fully parameterized function
		}
	i1=i1+1; if(i1==NPAR1)i1=0; i2=i2+1; if(i2==NPAR2)i2=0
	}
return
end
