FUNCTION rreg (
	x		/MATRIX/
	y		/REAL/
	w		/REAL,NROW(x)/
	int		/LGL,1,TRUE/
	init		/REAL,NCOL(x)+1/
	method		/CHAR,1,STRING(default)/
	wx		/REAL,OPTIONAL/
	iter		/INT,1,20/
	k		/REAL,2/
	acc		/REAL,1,10.*sqrt(PRECISION)/
	stop		/INT,1,1/
	conv		/LGL,1,FALSE/
	)
STATIC( integer meth(2),match,indx; logical convr )
CTABLE(meths,andrews,bisquare,cauchy,fair,huber,logistic,talworth,welsch)
STATIC( real factor(8) )
INITIAL( factor/1.339, 4.685, 2.385, 1.4, 1.345, 1.205, 2.795, 2.986/ )
STATIC( integer iiter,i; POINTER testv; logical done )
STATIC( real rrxwr,delta,rrscal,dot,dotv )
nobs=NROW(x); convr=conv
nc=NCOL(x); if(int) nc=nc+1

STRUCTURE(
	coef		/REAL,nc/
	resid		/LIKE(y)/
	conv		/REAL,iter+2/
	)
if (!MISSING(method)) {
	indx=match(method,meths)
	if(indx<=0)ABORT(C(TEXT(method))," is not a valid method")
	nmeth=1; meth(1)=indx
	}
else {nmeth=2; meth(1)=5; meth(2)=2}
if(MISSING(k)){
	LENGTH(k)=nmeth
	do imeth=1,nmeth { k[imeth]=factor(meth(imeth)) }
	}
if(LENGTH(k)!=nmeth) FATAL(Wrong length for k vector)
if(nobs!=LENGTH(y))FATAL(Must have same number of observations in x and y)
if(!MISSING(init) & nc!=LENGTH(init)) FATAL(Must have same number of initial values as coefficients)
if(LENGTH(w)!=nobs)FATAL(Number of weights must equal number of observations)
if(MISSING(w))call rfill(1.,w,nobs)
else do i=1,nobs
	if(w[i]>=0)w[i]=sqrt(w[i]); else FATAL(Negative w value)
if(!MISSING(wx)) {
	if(LENGTH(wx)!=nobs)FATAL(Length of wx must equal number of observations)
	do i=1,nobs {
		if(wx[i]>=0)wx[i]=sqrt(wx[i]); else FATAL(Negative wx value)
		w[i]=w[i]*wx[i]
		}
	}
if(MISSING(init)) call rrwtls(x,nobs,NCOL(x),y,w,int,init,resid)
else if(LENGTH(init)!=nc) FATAL(Wrong length init vector)


switch(stop) {
	case 1: ntest=nobs; testv=VALUE(resid)
	case 2: ntest=nc; testv=VALUE(coef)
	case 3: ntest=nobs; testv=VALUE(w)
	case 4: ntest=0; testv=VALUE(w)
	}
STRUCTURE(testpv/REAL,ntest/)

call rcopy(init,coef,nc)
do i=1,nobs
	if(int) resid[i]=-dot(-y[i]+coef[1],x[i,1],nobs,NCOL(x),coef[2],1)
	else    resid[i]=-dot(-y[i],x[i,1],nobs,NCOL(x),coef[1],1)
icon=0
do imeth=1,nmeth {
	done=FALSE
	for(iiter=1; iiter<=iter; iiter=iiter+1) {
		icon=icon+1
		call rcopy(rs(testv),testpv,ntest)
		scale=rrscal(resid,nobs)
		call rrweit(resid,nobs,scale,k[imeth],meth(imeth),w)
		if(!MISSING(wx)) do i=1,nobs { w[i]=w[i]*wx[i] }	# adjust for wx weights
		if(stop==4) {
			conv[icon]=rrxwr(x,nobs,NCOL(x),w,resid,int)
			done = conv[icon]<=acc
			if(done)break
			}
		call rrwtls(x,nobs,NCOL(x),y,w,int,coef,resid)
		if(stop!=4) {
			conv[icon]=delta(testpv,rs(testv),ntest)
			done = conv[icon]<=acc
			if(done) break
			}
		}
	if (!done & imeth == 1) {
		EPRINT("Warning: rreg failed to converge in",I(iiter-1)," steps")
		break
		}
	iter=2	# no of iters for second step
	acc=0.	# force full number of iterations second step
	}
if (!MISSING(wx)) do i=1,nobs { if(wx[i]!=0) w[i]=w[i]/wx[i] }
do i=1,nobs { w[i]=w[i]**2 }
LENGTH(conv)=icon
RETURN(coef, resid, w, int, method, k, &)
if(convr) RETURN(conv, &)
END
