#ptr      ptr - power transform of xml into xtr
subroutine ptr(xml,nn,powout,xtr)
real xml(1),xtr(1)
#
#  sabl error flag
common/errcm/ierr
#
if (nn<=0) {
	ierr = 2
	ierrno = 163
	call ewrt(ierrno)
	}
else {
#
	zero = zrol(zl)
	if (abs(powout-1.0)>=zero) {
		if (abs(powout)<zero) {
#
#  transformation power = log
			do i = 1,nn {
				if (xml(i)<=0.)
					go to 10
				xtr(i) = alog(xml(i))
				}
			return
			}
		else if (abs(powout+1.0)<zero) {
#
#  transformation power = inverse
			sz = I1MACH(10)
			sz = sz**(I1MACH(12)+2)
			do i = 1,nn {
				if (abs(xml(i))<sz)
					go to 10
				xtr(i) = -1.0/xml(i)
				}
			return
			}
		else if (powout<0.) {
#
#  transformation power not log, asis or inverse.  pow.lt.0
			do i = 1,nn {
				if (xml(i)<=0.)
					go to 10
				xtr(i) = -(xml(i))**powout
				}
			return
			}
		else {
#
#  transformation power not log, asis or inverse.  pow.gt.0
			do i = 1,nn {
				if (xml(i)<0.)
					go to 10
				xtr(i) = xml(i)**powout
				}
			return
			}
#
#  error
		10  ierr = 3
		ierrno = 40
		call ewrt(ierrno)
		powout = 1.0
		}
#
#  transformation power = 1.0
	call rmovf(xml,(nn),xtr)
	}
return
end



