#regad    regad - update regression to add new observation x,y
subroutine regad(r,ip,ipdim,w,x,y)
#
#  arguments
#  r=     upper-triangle from previous x data,  updated
#  ip=    number of rows in r, w, x
#  ipdim= number of rows dimensioned for r
#  w=     vector of projections of y data on x data,  updated
#  x=     data to be added to r
#  y=     data to be added to w
#
real r(ipdim,1),w(1),x(1)
#
#  eps chosen so 1+eps just larger than 1
eps = float(I1MACH(10))**(1-I1MACH(11))
#
do j = 1,ip
#  skip rotation if element already zero
	if (abs(x(j))>eps*r(j,j)) {
		d = sqrt(r(j,j)**2+x(j)**2)
		cos = r(j,j)/d
		sin = x(j)/d
		r(j,j) = d
		if (j<ip) {
#
			j1 = j+1
			do kk = j1,ip {
				c1 = r(j,kk)*cos+x(kk)*sin
				c2 = -r(j,kk)*sin+x(kk)*cos
				r(j,kk) = c1
				x(kk) = c2
				}
			}
#
		c1 = w(j)*cos+y*sin
		c2 = -w(j)*sin+y*cos
		w(j) = c1
		y = c2
		}
return
end



