#sablc    sablc - adjust series for calendar/day of week
subroutine sablc(xtr,imonth,iyear,lmonth,lyear,ntre,nsea,powout,iwcal,cpc,xc)
real xtr(1),cpc(1),xc(1),calp(8),hol(7)
#
#  xtr and xc are dimensioned as length of series
#  cpc nis dimensioned as xtr+12 for predictions of calendar
#
#
#  sabl error flag
common/errcm/ierr
#
data hol(1),hol(2),hol(3),hol(4),hol(5),hol(6),hol(7)/1.,0.,1.,1.,0.,0.,1./
data ieast/0/
data iyyes/1/
#
#  check argument values
imo = imonth
lmo = lmonth
if (imonth<=0||imonth>12)
	imo = 1
if (lmonth<=0||lmonth>12)
	lmo = 12
nn = (lyear-iyear)*12+(lmo-imo+1)
if (nn<=0) {
#
#  error
	ierr = 2
	ierrno = 102
	call ewrt(ierrno)
	}
else {
#
#  regression to estimate day of week and easter coef.
	call cfit(xtr,imo,iyear,lmo,lyear,ieast,hol,ntre,nsea,powout,calp,crsq,cpc,xc)
	if (ierr!=2) {
#
#  estimate calendar/day of week component
		call ccom(calp,imo,iyear,lmo,lyear+1,ieast,hol,powout,cpc)
		if (ierr!=2) {
#
#  adjust xtr for calendar/day of week
			call subt(xtr,cpc,nn,xc)
#
#  print calendar coefficients and rsq
			if (iwcal==iyyes)
				continue
			return
			}
		}
	continue
	}
return
end



