#computes singular value decomposition of a rectangular matrix
FUNCTION svd(x/MATRIX/,&)
STATIC( integer n,p,ncu,ncv,l )
n=NROW(x); p=NCOL(x); l=min0(NROW(x),NCOL(x))

ARG(
	nu	/INT,1,l/
	nv	/INT,1,l/
	)
STRUCTURE(u,v,d/REAL,l/)
CHECK(nu==0|nu==p|nu==n,FATAL(Bad value for nu))
CHECK(nv==0|nv==p|nv==n,FATAL(Bad value for nv))
if(nu>0) ALLOCATE(u/MATRIX,n,nu/)
if(nv>0) ALLOCATE(v/MATRIX,p,nv/)
call svd(x,n,p,u,nu,d,v,nv)
RETURN(d, &)
if(nu>0)RETURN(u,&)
if(nv>0)RETURN(v,&)
END
