function fdeltz(l1, r1, u1, d1, l2, r2, u2, d2, angle)
real l1, r1, u1, d1, l2, r2, u2, d2, angle, t, a
# Computes the distance between the centers of two adjacent boxes inclined
# at angle degrees. The top-right and bottom-left coordinates of (unrotated)
# box i are (ri,ui) and (li,di).

a = angle
for(; a < 0; a = a + 360.0)
	;
a = amod(a, 360.0)
for(; a >= 90.0; a = a - 90.0) {
	t=l1; l1=-u1; u1=r1; r1=-d1; d1=t
	t=l2; l2=-u2; u2=r2; r2=-d2; d2=t
}
a = a * DEG2RD
if(a == 0.0)
	return(r1-l2)
else
	return(min(abs((r1-l2)/cos(a)), abs((u2-d1)/sin(a))))

end
