ROUTINE(dmarkz,		draw plotting symbol marks at points)
subroutine dmarkz(xx,yy,n,marker)
real xx(n),yy(n),x(9),y(9)
INCLUDE(graphics)
logical nl,poly
define(`MAXACTION',2) define(`NSYMBOL',19)
integer action(NSYMBOL,MAXACTION)
equivalence(x(1),x1),(x(2),x2),(x(3),x3),(x(4),x4),(x(5),x5),(x(6),x6),(x(7),x7),(x(8),x8),(x(9),x9),(y(1),y1),(y(2),
  y2),(y(3),y3),(y(4),y4),(y(5),y5),(y(6),y6),(y(7),y7),(y(8),y8),(y(9),y9)
data ((action(i,j),j=1,MAXACTION),i=1,NSYMBOL)/_
	1,0,	# 0 square
	2,0,	# 1 octagon
	3,0,	# 2 triangle
	4,0,	# 3 cross
	5,0,	# 4 x
	6,0,	# 5 diamond
	7,0,	# 6 inverted triangle
	1,5,	# 7 square and x
	4,5,	# 8 cross and x
	4,6,	# 9 diamond and cross
	2,4,	# 10 octagon and cross
	3,7,	# 11 two triangles
	1,4,	# 12 square and cross
	2,5,	# 13 octagon and x
	8,0,	# 14 triangle in box
	-1,0,	# 15 solid square
	-2,0,	# 16 solid octagon
	-3,0,	# 17 solid triangle
	-6,0/	# 18 solid diamond
if (marker<0||marker>=NSYMBOL)return
QUERY( mkh(ht), csi(dht), uin(cx,cy) )
if(ht<=0.)
	ht = 0.8*dht
dx = ht/(2.0*cx)
dy = ht/(2.0*cy)
dxh = dx/2.0
dyh = dy/2.0
m = marker+1
nl = FALSE
do i = 1,n {
	for(j=1; action(m,j)!=0 & j<=MAXACTION; j=j+1){
		nl = FALSE
		poly = action(m,j) < 0
		switch(iabs(action(m,j))) {
		case 1: #square
			x1 = xx(i)-dx;	x2 = xx(i)+dx;	x3 = x2;	x4 = x1;	x5 = x1
			y1 = yy(i)+dy;	y2 = y1;	y3 = yy(i)-dy;	y4 = y3;	y5 = y1
			np = 5
		case 2:	#octagon
			x1 = xx(i)-dxh;	x2 = xx(i)+dxh;	x3 = x2+dxh;	x4 = x3;	x5 = x2
			y1 = yy(i)+dy;	y2 = y1;	y3 = y2-dyh;	y4 = y3-dy;	y5 = y4-dyh
			x6 = x1;	x7 = x6-dxh;	x8 = x7;	x9 = x1
			y6 = y5;	y7 = y4;	y8 = y3;	y9 = y1
			np = 9
		case 3:	#triangle
			x1 = xx(i);	x2 = x1+dx;	x3 = x1-dx;	x4 = x1
			y1 = yy(i)+dy;	y2 = yy(i)-dy;	y3 = y2;	y4 = y1
			np = 4
		case 4:	# cross
			x1 = xx(i)+dx;	x2 = xx(i)-dx
			y1 = yy(i);	y2 = y1
			x3 = xx(i);	x4 = x3
			y3 = y1+dy;	y4 = y1-dy
			np = 2
			nl = TRUE
			np2 = 2
		case 5:	# x
			x1 = xx(i)-dx;	x2 = xx(i)+dx
			y1 = yy(i)+dy;	y2 = yy(i)-dy
			x3 = x1;	x4 = x2
			y3 = y2;	y4 = y1
			np = 2
			nl = TRUE
			np2 = 2
		case 6:	#diamond
			x1 = xx(i);	x2 = x1+dx;	x3 = x1;	x4 = x1-dx;	x5 = x1
			y2 = yy(i);	y1 = y2+dy;	y3 = y2-dy;	y4 = y2;	y5 = y1
			np = 5
		case 7:	#inverted triangle
			x3 = xx(i);	x1 = x3-dx;	x2 = x3+dx;	x4 = x1
			y1 = yy(i)+dy;	y2 = y1;	y3 = yy(i)-dy;	y4 = y1
			np = 4
		case 8:	# triangle in box
			x1 = xx(i)-dx;	x2 = x1;	x3 = xx(i)+dx;	x4 = x3
			y1 = yy(i)-dy;	y2 = yy(i)+dy;	y3 = y2;	y4 = y1
			x5 = x1;	x6 = xx(i);	x7 = x4
			y5 = y1;	y6 = y2;	y7 = y1
			np = 7
			}
		if(poly) call polyz(x,y,np-1)	# polygons automatically close
		else call linesz(x,y,np)
		if (nl) call linesz(x(np+1),y(np+1),np2)
		}
	}
return
end
