ROUTINE(logaxz,		determine and plot log axis)
subroutine logaxz(iside,istyle,u1,u2,nl,isw)
INCLUDE(graphics)
logical plot,set,specif,yaxis
CHARACTER(istyle,1); CHARACTER(isnew,1)
CHARACTER(it,1); CHARACTER(is,1)
plot = mod(isw,2)==1
set = isw/2==1
yaxis = mod(iside,2)==0
QUERY( axp(iside,it,is,ua,ub,par) )
if (it!="n") it = "l"
ua = u1; ub = u2
if (ua==ub) { ua = ua*.5; ub = ub*2. }
call zstylz(is,istyle,isnew,igo)
is = isnew
specif = TRUE
switch(igo) {
	case 1: # standard - use data limits, extend if needed
		call zlintz(ua,ub,nl,nd,idec)
		ul = ua
		ur = ub
	case 2,4,7: # internal, direct, rational
		if(u1==u2) du=2.
		else if(igo==7) du=(u2/u1)**(.04)	# 4% extra for r
		else du=1
		ul = u1/du
		ur = u2*du
		ua=ul; ub=ur
		call zlintz(ub,ua,nl,nd,idec)
		ul = amin1(ul,ua)
		ur = amax1(ur,ub)
	case 3: # extended - allow half char extra space
		QUERY( cin(cx,cy), pin(px,py) )
		if (!yaxis) du = 10.**(alog10(u2/u1)*0.5*cx/px)
		else du = 10.**(alog10(u2/u1)*0.5*cy/py)
		ul = ua
		ur = ub
		call zlintz(ua,ub,nl,nd,idec)
		if (ul/du<ua) ul = ul/du
		if (ur*du>ub) ur = ur*du
		ul = amin1(ul,ua)
		ur = amax1(ur,ub)
	case 5: # type not found - treat as temporary direct
		SPECIFY( axs(iside,is) )
		specif = FALSE; set = FALSE
	case 6:
		specif = FALSE; set = FALSE
	}
if(specif) SPECIFY( axp(iside,it,is,ua,float(nd),float(idec)) )
if (set) {
	ul1 = alog10(ul)
	ul2 = alog10(ur)
	if (yaxis) SPECIFY( usr(,,ul1,ul2) )
	else SPECIFY( usr(ul1,ul2) )
	}
if (plot && it!="n") call laxisz(iside,TRUE,TRUE)
return
end
