ROUTINE(stdaxz,		standard (linear) axis)
subroutine stdaxz(iside,istyle,u1,u2,nin,isw)
INCLUDE(graphics)
logical plot,set,yaxis,specif
CHARACTER(istyle,1); CHARACTER(it,1); CHARACTER(is,1)
CHARACTER(isnew,1)
plot = mod(isw,2)==1
set = isw/2==1
yaxis = mod(iside,2)==0
QUERY( axp(iside,it,is,ua,ub,par) )
if (it!="n") it = "s"
ua = u1
ub = u2
nl = nin
if (ua==ub) {
	eps = amax1(abs(ua)*.25,1e-2)
	ua = ua-eps
	ub = ub+eps
	}
call zstylz(is,istyle,isnew,igo)
is = isnew
specif = TRUE
switch(igo) {
	case 1: # standard - use data limits, extend if needed
		call zuintz(ua,ub,nl,dist)
		ul = ua
		ur = ub
	case 2,7: # internal interval, rational (extend 4%)
		if(igo==7) du = .04*(u2-u1); else du=0
		ua = ua - du
		ub = ub + du
		ul = ua; ur = ub
		call zuintz(ub,ua,nl,dist)
	case 3: # extended - allow half char extra space
		QUERY( cin(cx,cy), pin(px,py) )
		if (!yaxis) du = (ub-ua)*0.5*cx/px
		else du = (ub-ua)*0.5*cy/py
		ul = ua
		ur = ub
		call zuintz(ua,ub,nl,dist)
		if (ul-ua<du) ul = ul-du
		if (ub-ur<du) ur = ur+du
		ul = amin1(ul,ua)
		ur = amax1(ur,ub)
	case 4: # direct axis - set user coords
		ul = ua
		ur = ub
	case 5: # type not found - treat as temporary direct
		SPECIFY( axs(iside,is) )
		specif = FALSE; set = FALSE
	case 6:
		specif = FALSE; set = FALSE
	}
if(specif) SPECIFY( axp(iside,it,is,ua,ub,float(nl)) )
if (set) {
	if (yaxis) SPECIFY( usr(,,ul,ur) )
	else SPECIFY( usr(ul,ur) )
	}
if (plot&&it!="n") call saxisz(iside,TRUE,TRUE)
return
end
