SUPPORT(vaxisz,		produce axis from vector of points and/or labels)
subroutine vaxisz(iside,xllab,xlline,u,ulabs,labs,nl,lena,iwhich)
INCLUDE(graphics,stack,print)
# plots axis and ticks at u(i), if iwhich.ge.0
# plots labels at u(i) if iwhich.ne.0 -
# takes labels as encoded u(i) or ulabs(i), or as pointers to strings in labs
# u() MUST BE SORTED
real u(nl),ulabs(nl),uncp(2),umin,umax
logical xpd,paral,obliq,cfmt,xaxis
POINTER labs(nl)
integer wid,dec
xaxis = mod(iside,2) == 1
leng = lena
isw = iabs(iwhich)
QUERY( xpd(xpd) )
if (!xpd) SPECIFY( xpd(TRUE) )
if (iwhich>=0) {	# axis and ticks
	QUERY( tck(tck) )
	call vtickz(iside,xlline,u,nl,tck)
	}
if (isw!=0&&leng>=1) {	# numeric or text labels
	call zmtouz(iside,xllab,vlab)
	QUERY( cin(cw,ch), srt(srt) )
	if (!xaxis) { art = 90.; lu = 2; lv = 1; QUERY( uin(vi,ui), usr(,,umin,umax) ) }
	else        { art = 0.;  lu = 1; lv = 2; QUERY( uin(ui,vi), usr(umin,umax) ) }
	cfmt = FALSE
	if (isw>=10) { # choose a single format
		isw = mod(isw,10)
		cfmt = TRUE
		if (isw==1) call rdtfmt(u,nl,leng,wid,dec)
		if (isw==2) call rdtfmt(ulabs,nl,leng,wid,dec)
		}
	paral = amod(abs(srt-art)+15.,180.)<30.	# strings parallel if within 15 deg of axis
	obliq = (amod(abs(srt-art-90.)+15.,180.)>=30.)&&(!paral)
	if (!paral) adj=.5; else QUERY( adj(adj) )
	if (obliq) vi = vi*cos(srt-art)/sin(srt-art)
	pos = 0.
	u1 = u(1)
	plast = 0
	do i = 1,nl {
		if(u(i)<umin|u(i)>umax) next	# skip labels outside of user coord bounds
		if (isw>2)  ENCODE(C(TEXT(labs(i))),C(EOS,1))	# text label
		else { # encode the label
			if (isw>1) uu = ulabs(i)
			else uu = u(i)
			if (cfmt) ENCODE(R(uu,leng,wid,dec),C(EOS,1))	# common format
			else ENCODE(R(uu,0),C(EOS,1))
			call eatblz(BUFFER)	# get rid of blanks
			call zffmtz(BUFFER)	# find "e", insert NEWLINE if needed
			}
		if (paral) {	# length of this label
			call lenstz(BUFFER,w,ncact)
			w = w+cw
			}
		else w = ch
		pos = pos+(u(i)-u1)*ui
		if (pos-plast>=w*adj||i<=1) { # skip if no room for label
			if(!xaxis) SPECIFY( ncp(vlab,u(i)) )	# certain devices (batch) ncp not set
			else       SPECIFY( ncp(u(i),vlab) )	# provide defaults
			call gtextz(iside,xllab,u(i),BUFFER)
			if (paral) plast = pos+w*(1.-adj)
			else { # find last position, allow for multi-line labels
				QUERY( ncp(uncp(1),uncp(2)) )
				if (obliq) plast = pos+amax1(ch*.5,(uncp(lu)-u(i))*ui+abs(uncp(lv)-vlab)*vi)
				else plast = pos+amax1(ch*.5,(uncp(lu)-u(i))*ui)
				}
			}
		u1 = u(i)
		CLEAR
		}
	}
if (!xpd) SPECIFY( xpd(FALSE) )
return
end
