/* main program for stand-alone GR-Z device drivers */
define(`PMODE',`0644')	/* RW for owner, R group, others */
define(`INITIALIZE',`
#include <ctype.h>
	int from[2],to[2],pid,fd,iarg;
	char *fname=NULL,slash; float pm[10]; long npm=0;
	slash= "/ "[0];	/* hard to put apos inside macro definition */
	iarg=strlen(argv[0]);
	for(iarg--; iarg>=0 && argv[0][iarg]!=slash; iarg --);
	argv[0] = argv[0]+iarg+1;
	for(iarg=1; iarg<argc; iarg++)	/* process args */
		if(isalpha(argv[iarg][0])) fname=argv[iarg];
		else sscanf(argv[iarg],"%f",pm+(int)npm++);
	if(fname){	/* graphics to file */
		if((fd=creat(argv[1],PMODE))==-1){
			fprintf(stderr,"Cannot open %s\n",argv[1]);
			exit(1);
			}
		}
	pipe(to); pipe(from);
	pid = fork();
	if(pid == 0){	/* child */
		close(to[1]); close(from[0]);
		if( sdup2(to[0],INPIPE) == -1)FATAL(cannot create graphics pipe)
		close(to[0]);	/* input on INPIPE */
		if( sdup2(from[1],OUTPIPE) == -1)FATAL(cannot create graphics pipe)
		close(from[1]);	/* output on OUTPIPE */
		execl("/bin/sh","sh",0);	/* invoke shell */
		}
	fprintf(stderr,"%s driver activated\n",argv[0]);
	if(fname){	/* reset stdout to go to specified file */
		close(1); dup(fd); close(fd);
		}
	F77_CALL(fixarg,char=argv[0],real=pm,int=&npm);	/* device dependent arg fixing */
	F77_CALL(pbegnz,real=pm,int=&npm);	/* initialize */
	first=0; F77_CALL(winitz);
	F77_COM(bgrp)[120]=1;	/* new=FALSE */
	if(F77_COM(bgrp)[29]>0){ n=2; n2=6; F77_CALL(wcopyz,int=&n,char="sgraph",int=&n2); }	/* defer on for grafpac */
	interact = isatty(2) || F77_COM(bgrp)[29]==PRINTER;
	close(to[0]); close(from[1]);
	if( sdup2(to[1],OUTPIPE) == -1)FATAL(cannot create graphics pipe)
	close(to[1]);	/* write on OUTPIPE */
	if( sdup2(from[0],INPIPE) == -1)FATAL(cannot create graphics pipe)
	close(from[0]);	/* read on INPIPE */
')
define(`TERMINATE',`
	fprintf(stderr,"%s driver terminating\n",argv[0]);
')
INCLUDE(u/driver)
