INCLUDE(amsave)
#include <signal.h>
#define INFILE 15
#define OUTFILE 16
#define DEAF istat=signal(SIGINT, SIG_IGN)
#define LISTEN signal(SIGINT,istat)
define(`am',`(F77_COM(bgrp)[($1)-1])')
int (*istat)();
char which;
int firtim = 1;
extern float F77_COM(bgrp)[], F77_COM(obgrp)[];

F77_SUB(ztextz,real=x,real=y,char=text,int=n,real=pos)
{
	r_ztextz(F_REALP(x),F_REALP(y),F_CHARP(text),F_INTP(n),F_REALP(pos));
}

static r_ztextz(x,y,text,n,pos)
float *x,*y,*pos;
char *text;
long int *n;
{
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='T'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,n,sizeof(*n));
	pwrite(OUTFILE,x,sizeof(*x));
	pwrite(OUTFILE,y,sizeof(*y));
	pwrite(OUTFILE,pos,sizeof(*pos));
	pwrite(OUTFILE,text,(int)*n);
	confirm('T');
	read(INFILE,& am(86),2*sizeof(float));	/* update am(86), am(87) (NCP) */
	LISTEN;
}

F77_SUB(zlinsz,real=x,real=y,int=n)
{
	r_zlinsz(F_REALP(x),F_REALP(y),F_INTP(n));
}

static r_zlinsz(x,y,n)
float *x,*y;
long *n;
{
	int i;
	i = *n;
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='L'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,n,sizeof(*n));
	pwrite(OUTFILE,x,i*sizeof(*x));
	pwrite(OUTFILE,y,i*sizeof(*y));
	confirm('L');
	read(INFILE,&am(6),2*sizeof(float));	/* update am(6), am(7) (LPP) */
	LISTEN;
}


F77_SUB(zpntsz,real=x,real=y,int=n)
{
	r_zpntsz(F_REALP(x),F_REALP(y),F_INTP(n));
}

static r_zpntsz(x,y,n)
float *x,*y;
long *n;
{
	int i;
	i = *n;
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='P'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,n,sizeof(*n));
	pwrite(OUTFILE,x,i*sizeof(*x));
	pwrite(OUTFILE,y,i*sizeof(*y));
	confirm('P');
	read(INFILE,&am(6),2*sizeof(float));	/* update am(6), am(7) (LPP) */
	LISTEN;
}


F77_SUB(zsegsz,real=x,real=y,real=x2,real=y2,real=n)
{
	r_zsegsz(F_REALP(x),F_REALP(y),F_REALP(x2),F_REALP(y2),F_INTP(n));
}

static r_zsegsz(x,y,x2,y2,n)
float *x,*y,*x2,*y2;
long *n;
{
	int i;
	i = *n;
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='S'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,n,sizeof(*n));
	pwrite(OUTFILE,x,i*sizeof(*x));
	pwrite(OUTFILE,y,i*sizeof(*y));
	pwrite(OUTFILE,x2,i*sizeof(*x2));
	pwrite(OUTFILE,y2,i*sizeof(*y2));
	confirm('S');
	read(INFILE,&am(6),2*sizeof(float));	/* update am(6), am(7) (LPP) */
	LISTEN;
}

F77_SUB(zpolyz,real=x,real=y,int=n)
{
	r_zpolyz(F_REALP(x),F_REALP(y),F_INTP(n));
}

static r_zpolyz(x,y,n)
float *x,*y;
long int *n;
{
	int i;
	i = *n;
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='G'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,n,sizeof(*n));
	pwrite(OUTFILE,x,i*sizeof(*x));
	pwrite(OUTFILE,y,i*sizeof(*y));
	confirm('G');
	read(INFILE,&am(6),2*sizeof(float));	/* update am(6), am(7) (LPP) */
	LISTEN;
}

F77_SUB(zejecz)
{
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='E'; pwrite(OUTFILE,&which,1);
	confirm('E');
	LISTEN;
}


F77_SUB(zwrapz)
{
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='W'; pwrite(OUTFILE,&which,1);
	confirm('W');
	LISTEN;
}


F77_SUB(zrdpnz,real=x,real=y,int=n,int=nmax)
{
	r_zrdpnz(F_REALP(x),F_REALP(y),F_INTP(n),F_INTP(nmax));
}

static r_zrdpnz(x,y,n,nmax)
float *x,*y;
long int *n, *nmax;
{
	int i;
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='Q'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,nmax,sizeof(*nmax));
	confirm('Q');
	read(INFILE,n,sizeof(*n)); i = *n;
	if(i>0){
		read(INFILE,x,i*sizeof(*x));
		read(INFILE,y,i*sizeof(*y));
		}
	LISTEN;
}


F77_SUB(zinitz)
{
	int i; long int n;
	if(!firtim) return;
	DEAF;
	which='I'; pwrite(OUTFILE,&which,1);
	i = pread(INFILE,F77_COM(bgrp),200*sizeof(float));
	if(i < (int)(200*sizeof(float))) FATAL(Device not active)
	LISTEN;
	firtim = 0;
	n = AMLAST; F77_CALL(rcopy,real=F77_COM(bgrp),real=F77_COM(obgrp),int=&n);
	}

F77_SUB(zbgrpz)
{	/* get new copy of bgrp parameter array */
	int i; long int n;
	DEAF;
	which='I'; pwrite(OUTFILE,&which,1);
	i = pread(INFILE,F77_COM(bgrp),200*sizeof(float));
	if(i < (int)(200*sizeof(float))) FATAL(Device not active)
	LISTEN;
	n = AMLAST; F77_CALL(rcopy,real=F77_COM(bgrp),real=F77_COM(obgrp),int=&n);
	}


F77_SUB(parout,char=ich,int=n,real=x)
{
	r_parout(F_CHARP(ich),F_INTP(n),F_REALP(x));
}

static r_parout(ich,n,x,leng)
char *ich;
long *n;
float *x;
{
	DEAF;
	pwrite(OUTFILE,ich,1);
	pwrite(OUTFILE,n,sizeof(*n));
	pwrite(OUTFILE,x,(int)(*n)*sizeof(float));
	confirm(*ich);
	LISTEN;
}

confirm(c)
char c;
{
	long n;
	if(read(INFILE,&which,1)!=1) {
		LISTEN;
		FATAL(Problem talking with device driver across pipe)
		}
	else if(which=='B'){	/* device driver got interrupt */
		LISTEN;
		kill(getpid(),SIGINT);	/* send interrupt to myself */
		}
	else if(which=='A'){	/* abort in device driver */
		LISTEN;
		F77_CALL(zzabt);
		}
	else if(which=='R'){	/* device was reshaped */
		pread(INFILE,F77_COM(bgrp),200*sizeof(float));
		n = AMLAST; F77_CALL(rcopy,real=F77_COM(bgrp),real=F77_COM(obgrp),int=&n);
		}
	else if(which!=c){
		fprintf(stderr,"Mismatch: wanted '%c', got '%c'\n",c,which);
		exit(1);
		}
}

F77_SUB(zcopyz,int=mode,char=file,int=n)
{
	r_zcopyz(F_INTP(mode),F_CHARP(file),F_INTP(n));
}

static r_zcopyz(mode, file, n)
long *mode; char *file; long *n;
{
	which='C'; DEAF;
	pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,mode,sizeof(*mode));
	pwrite(OUTFILE,n,sizeof(*n));
	pwrite(OUTFILE,file, (int) *n);
	confirm('C');
	LISTEN;
}

F77_SUB(zparmz,real=x,int=n)
{
	r_zparmz(F_REALP(x),F_INTP(n));
}

static r_zparmz(x,n)
float *x; long *n;
{
	int i;
	if(!firtim) return;
	i = *n;
	DEAF;
	which = 'M'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE,n,sizeof(*n));
	if(i > 0) pwrite(OUTFILE,x,sizeof(*x)*i);
	i = pread(INFILE,F77_COM(bgrp),200*sizeof(float));
	if(i < (int)(200*sizeof(float))) FATAL(Device not active)
	LISTEN;
	firtim = 0;
	*n = AMLAST; F77_CALL(rcopy,real=F77_COM(bgrp),real=F77_COM(obgrp),int=n);
	}

F77_SUB(zhookz,int=type,real=x,int=n,real=y,int=m)
{
	r_zhookz(F_INTP(type),F_REALP(x),F_INTP(n),F_REALP(y),F_INTP(m));
}

static r_zhookz(type, x, n, y, m)
long *type, *n, *m;
float *x, *y;
{
	int i, newm;

	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='H'; pwrite(OUTFILE,&which,1);
	pwrite(OUTFILE, type, sizeof(*type));
	pwrite(OUTFILE, n, sizeof(*n));
	if(*n > 0)
		pwrite(OUTFILE, x, *n * sizeof(*x));
	pwrite(OUTFILE, m, sizeof(*m));
	i = pread(INFILE, &newm, sizeof(newm));
	if(i < sizeof(newm))
		FATAL(Device not active)
	if(newm > 0) {
		if(newm > *m) {
			WARNING(Device hook overflowed; overflow ingored)
			newm = *m;
		}
		pread(INFILE, y, newm * sizeof(*y));
	}
	confirm('H');
	LISTEN;
	return(newm);
}

F77_SUB(zlengz,char=text,real=inches)
{
	r_zlengz(F_CHARP(text),F_REALP(inches));
}

static r_zlengz(text,inches)
char *text;
float *inches;
{
	long n;
	if(firtim) FATAL(Device not active)
	F77_CALL(saveam);
	DEAF;
	which='l'; pwrite(OUTFILE,&which,1);
	n = strlen(text);
	pwrite(OUTFILE,n,sizeof(n));
	pwrite(OUTFILE,text,(int)n);
	confirm('l');
	read(INFILE,inches,sizeof(float));
	LISTEN;
}
