#include "icdef.h"
#define input(z) getc(yyin)
#define COPY text[leng++]=yytext[0]
#define TERMINATE text[leng]=0
string() {
#include "extern.h"
	/*
	returns:
	  0: null
	 *1: name
	  2: missing right-quote
	 *3: balanced quotes
	  4: missing double quote
	 *5: duoble quoted string
	  6: possibly signed dot
	 *7: integer
	 *8: real number
	  9: missing exponent
	 10: unadorned sign in exponent field
	*11: floating point number
	 12: missing new-line after comment
	*13: comment
	 14: unadorned sign

	"regular" grammar:

	   letter digit
	0,1      1     1

	 ` '
	0 2 3

	 " [^"] "
	0 4    4 5

	 [+-]
	0    14

	    digit digit .
	0,14     7     7 8

	   [Ee] [+-]
	7,8    9    10

	    digit  digit
	9,10     11     11

	    . digit
	0,14 6     8

	 #  [^\n]  \n
	0 12     12  13

	in state 2, all characters are alowed as long as there are not more
	right quotes than left quotes.

	The character classes represent input to a finite automaton.  The numbers
	below the input are its states.
	*/
	int qlevel, st;
	st=0;
	leng=0;
	qlevel=0;
	usedf=0;
	while(token!=0) {
		if(leng+yyleng>BUFFSIZE) {
			fprintf(stderr,"ERROR in line %d: string too long\n", yylineno);
			return(st);
			}
		switch(token) {
			case 'e': if(st==7|| st==8) {
					st=9; COPY; break;}
			case LETTER: switch(st) {
				case 0: st=1;
				case 1: COPY; break;
				default: TERMINATE;
					return(st); } break;
			case '`': switch(st) {
				case 0: st=2;
					qlevel++;
					COPY; break;
				default: TERMINATE;
					return(st); } break;
			case '"': switch(st) {
				case 0: st=4; COPY; break;
				default: TERMINATE;
					return(st); } break;
			case DIGIT: switch(st) {
				case 0:
				case 14: st=7; COPY; break;
				case 6: st = 8; COPY; break;
				case 9:
				case 10: st=11;
				case 1:
				case 7:
				case 11: COPY; break;
				default: TERMINATE;
					return(st); } break;
			case '.': switch(st) {
				case 7: st=8; COPY; break;
				case 0:
				case 14: st=6; COPY; break;
				default: TERMINATE;
					return(st); } break;
			case '+': switch(st) {
				case 9: st = 10; COPY; break;
				default: TERMINATE;
					return(st); } break;
			case '#': switch(st) {
				case 0: st=12; COPY; break;
				default: TERMINATE;
					return(st); } break;
			case '\n': switch(st) {
				default: TERMINATE;
					return(st); } break;
			default: TERMINATE;
				return(st);
			} /* end of switch */
		/* here st==2,4,or 12 iff a quote-like character was read */
		/* instead of using yylex, I'm getting characters by hand */
		if(st==2) {
			usedf=1;
			printf("%s",yytext);
			while((token=yylex())!=0) {
				printf("%s",yytext);
				if(yytext[0]=='`') qlevel++;
				else if(yytext[0]=='\047') {
					if(--qlevel ==0) {
						st=3;
						text[0]=0;
						return(st);
						}
					}
				}
			}
		else if(st==4) {
			usedf=1;
			printf("%s",yytext);
			while((token=yylex())!=0) {
				printf("%s",yytext);
				if(yytext[0]=='"') {
					st=5;
					text[0]=0;
					return(st);
					}
				}
			}
		else if(st==12) {
			usedf=1;
			printf("%s",yytext);
			while((token=yylex())!=0) {
				printf("%s",yytext);
				if(yytext[0]=='\n') {
					st=13;
					text[0]=0;
					return(st);
					}
				}
			}
		/* if anything bad happened, it will be detected in the next
		   pass thru the while */
		token=yylex();
		} /* end of while */
	TERMINATE;
	return(st);
	}/* end of function string*/
