ROUTINE(gtds,		get data structure (given file descriptor))
POINTER function gtds( fd )
integer fd

INCLUDE(struct,stack)
POINTER jstkgt
automatic entry, value, p, mode, file, length, nread
automatic stype, fd2, i, sname, np, tlen, vl, vr
POINTER entry, alcdir, value, p, gtds2, sgets, file, np
integer mode, length, nread, cseek, stype, copen, fd2,i, sname
integer xlen, tlen, vl, vr
define(`BADREAD',900)

entry=jstkgt(LENTRY, INT)
np = sgets(fd)# name
NAME(entry) = np
call cread(fd, is(entry+1), 2, INT, nread)
if(nread < 2) goto BADREAD
mode=MODE(entry); length=LENGTH(entry)
switch(mode) {
	case REAL, INT, LGL:
		value=jstkgt(length,mode); VALUE(entry)=value
		call cread(fd, is(value), length, mode, nread)
		if(nread < length) goto BADREAD

	case CHAR:
		value=jstkgt(length,INT); VALUE(entry)=value
		for(i=0; i<length; i=i+1){
			is(value+i) = sgets(fd)
			if(is(value+i) == NULL) is(value+i)=istrng(EOS,1)
			}

	case NEW_CHAR:
		MODE(entry) = CHAR
		value=jstkgt(length,INT); VALUE(entry)=value
		call cread(fd, tlen, 1, INT, nread)
		if(nread != 1) goto BADREAD
		is(value) = jstkgt(tlen, CHAR)
		call ccread(fd, TEXT(is(value)), tlen, CHAR, nread)
		if(nread != tlen) goto BADREAD
		for(i=1; i<length; i=i+1){
			vl = value + i
			vr = vl - 1
			is(vl) = is(vr) + xlen(is(vr))	# xlen counts EOS
			}

	case DATASET:
		file=sgets(fd)
		fd2 = copen(TEXT(file),READ)
		entry=gtds2(fd2) # recursive call through gtds2
		NAME(entry)=np
		call cclose(fd2)

	case STACK:
		nread = cseek(fd,0,1) # remember position
		if(cseek(fd,length,0) != length)FATAL(bad seek on stack file)
		entry = gtds2( fd ) #call itself recursively
		NAME(entry)=np
		nread = cseek(fd, nread, 0) #and return to original position

	case STR:
		call cread(fd, stype, 1, INT, nread)
		if(nread < 1)goto BADREAD
		sname = sgets(fd)
		value=alcdir(length,sname,stype)
		VALUE(entry) = value; value=value+LENTRY*LHDR
		for(i=0; i<length; i=i+1) {
			p = gtds2(fd)
			call pcopy(p, value, LENTRY, INT)
			value = value + LENTRY
			}

	case NULL, MISSING: #all done

	default:
		FATAL(gtds: bad mode for data)
	}

return( entry )
BADREAD FATAL(gtds: error in read)
return( NULL )
end

#gtds2		hide the recursion from the compiler
POINTER function gtds2(fd)
integer fd
POINTER gtds
return(gtds(fd))
end
