SUPPORT(prtvec,		print vector structure)
subroutine prtvec(ptr,parent,pname,quotes,header)
POINTER ptr,parent,pname; logical quotes,header
INCLUDE(struct, stack,print,option,io)
POINTER i,dirfnd,dirptr,pdim,ptsp,val
logical streq; integer j,iy,iz; real x

dirptr=VALUE(parent)
i=NAME(ptr)
if( i==USED ) return	# should never do this

if( i==NULL ) {	# Not special
	call prtvc2(ptr,quotes)
	return
	}

if(streq(TEXT(i),TSTRING(Tsp))) return
if(streq(TEXT(i),TSTRING(Dim))) return

if(!streq(TEXT(i),TSTRING(Data)) ) {	# just a vector of some sort
	FPRINT(OUTFC,C(TEXT(pname)))
	call prtvc2(ptr,quotes)
	return
	}

# we have a Data component

pdim=dirfnd(dirptr,TSTRING(Dim))
if(pdim!=NULL & header){
	FPRINT(OUTFC,"Array:")
	val = VALUE(pdim)
	ENCODE(I(is(val),0))
	for(j=1; j<LENGTH(pdim); j=j+1) ENCODE(" by",I(is(val+j)))
	FPRINT(OUTFC)
	SKIP(OUTFC)
	}

ptsp=dirfnd(dirptr,TSTRING(Tsp))
if(ptsp!=NULL & header){
	FPRINT(OUTFC,"Time-series:")
	val = VALUE(ptsp); x=rs(val+2)
	if(x==1.) ENCODE("start:",R(rs(val)),"   end:",R(rs(val+1)))
	else {
		iy=rs(val); iz=(rs(val)-float(iy))*x+1.5
		ENCODE("start:",I(iy),I(iz))
		iy=rs(val+1); iz=(rs(val+1)-float(iy))*x+1.5
		ENCODE("   end:",I(iy),I(iz))
		}
	if(x==1.) ENCODE("   Yearly")
	else if(x==12.) ENCODE("   Monthly")
	else if(x==4.) ENCODE("   Quarterly")
	else ENCODE("   nper:",R(x))
	FPRINT(OUTFC)
	SKIP(OUTFC)
	}

if( cut<LENGTH(ptr) ) call prtvc2(ptr,quotes)	# very long
else if(pdim!=NULL) call prtars(ptr,pdim,quotes)	# array
else if(ptsp!=NULL) call prttss(ptr,ptsp,quotes)	# time series
else {	# print vector-structure as vector
	FPRINT(OUTFC,C(TEXT(pname)))
	call prtvc2(ptr,quotes)
	}

return
end
