SUPPORT(yylex,		S lexical analysis, special actions)
integer function yylex(yylval)
POINTER yylval # pointer to value

INCLUDE(tokens,lexio,stack,read,print,struct,option)
INCLUDE(u/link) #for the quit on EOF
integer i; logical streq; POINTER ival,cptr
CHARACTER(prmpt,2);CHARACTER(op,2)
define(`NKEY',8)
define(`NEND',9)
integer end(NEND), oldlin; logical done,doinit
SAVE(oldlin,keywd,doinit)
CHARACTER( keywd,7,NKEY)
integer toktyp(eval(NKEY+1))

data end/TNAME,STRING,TINT,TREAL,RPAR,RBRACK,RBRACE,BREAK,NEXT/
data toktyp/FOR,IN,IF,ELSE,REPEAT,BREAK,NEXT,WHILE,TNAME/
data doinit/TRUE/

if(doinit){
	doinit = FALSE
	keywd(1) = TSTRING(for)
	keywd(2) = TSTRING(in)
	keywd(3) = TSTRING(if)
	keywd(4) = TSTRING(else)
	keywd(5) = TSTRING(repeat)
	keywd(6) = TSTRING(break)
	keywd(7) = TSTRING(next)
	keywd(8) = TSTRING(while)
	}
if(ltoken==END_OF_FILE)return(END_STAT) #terminate parse (will simulate quit)
done=FALSE;  if(ntoken==0) oldlin=nline
while( (!done) || (macro && yylex!=END_STAT) ) {
	oldpos=INPOS	# remember position before this token
	call dectok(yylex,yylval)	# get next token
	switch(yylex) { #special S conventions
	case TNAME: done=TRUE
		for(i=1; i<=NKEY; i=i+1)
			if(streq(TEXT(yylval),keywd(i)))break
		yylex=toktyp(i) #reserved name or still TNAME
		if(yylex==FOR | yylex==IF | yylex==WHILE){
			parlev=parlev+1
			if(parlev<=MAXPAR) pstack(parlev)="F"
			}
	case RPAR: if(macro && pstack(min0(MAXPAR,parlev))=="F") parlev=parlev-1
		   done=TRUE
	case NOT: if(INPOS==2 && ntoken==0) { #system command; execute & continue
			call concat(INBUF,1,INBUF,2,LASTCH-1)
			call excmd(INBUF,LASTCH-1)
			LENGTH(VALUE(expr))=0; nline=0; oldlin=0 #delete line
			INPOS=LASTCH+1
			}
		else done=TRUE
	case COMMENT: INPOS=LASTCH+1 #comment, throw it away & continue
	case QUESTION: macro = TRUE
	case NEW_LINE, CONTINUE: 
		if(yylex==NEW_LINE && !contin) for(i=1; i<=NEND; i=i+1)
			if(ltoken==end(i)){done=TRUE;break}
		if(done) #end of expr or subexpr.
			if(parlev==0)yylex=END_STAT
			else if(parlev>0 && pstack(parlev)=="{")
				 {yylex=SEMI; yylval=istrng(";",1)}
			else done=FALSE
		if(!done || (macro && yylex!=END_STAT)) {
			call lexlin(ntoken>0 || yylex==CONTINUE || macro)
			if(EOF)  {yylex = END_OF_FILE; break}
			for(i=oldlin+1; i<=nline; i=i+1) { #echo & diary
				if(ntoken>0 || yylex==CONTINUE || macro )prmpt="+ ";
				else prmpt="> "
				ival=ENTRY(VALUE(expr),i); cptr=is(VALUE(ival))
				if( (divers!=STDIN && mprint==1) || (divers==STDIN && mprint==2) || mprint>2 ) 
					PRINT(C(prmpt,2),C(TEXT(cptr)))
				if(diary>0) {
					if(divers!=STDIN) ENCODE(SP(4*nsou))
					FPRINT(diary,C(TEXT(cptr)))
					}
				}
			oldlin=nline
			}
	case SEMI: done=TRUE; if(parlev==0)yylex=END_STAT
	case UNBALANCED: macro=FALSE; yylex=UNKNOWN; done=TRUE
		MESSAGE(Unbalanced parentheses)
	case PERCENT: done=TRUE #special S operators
		if(INPOS<=LASTCH) { UNGETC; DECODE(GETC(op,2));yylval=istrng(op,2)}
		else ttype=UNKNOWN
	default: done=TRUE
		} #end switch
	}
contin = (yylex==RPAR && parlev>0 && pstack(parlev)=="F")
if(contin)parlev=parlev-1
if(ltoken==TNAME && ntoken==1 &&
  (yylex==TNAME || yylex==TINT ||yylex==TREAL || yylex==STRING))
	{yylex=TBLANK; INPOS=oldpos} #fun. call with blank before args
ltoken=yylex; ntoken=ntoken+1
return
end
