ROUTINE(eigen1,		get M largest or smallest eigenvals & vectors)
subroutine eigen1(A,n,m,values,vector,large)
#A: n by n **symmetric** matrix
#m: no. of eigenvalues & vectors wanted
#values: vector for output eigenvalues
#vector: n by m matrix for output eigenvectors (in columns)
#large: flag for largest(TRUE) or smallest(FALSE) eigenvalues
integer n,m; real A(n,n),values(n),vector(n,m); logical large

INCLUDE(stack)
POINTER fv1,fv2,fv3,fv4,fv5,fv6,fv7,fv8,iv1,jstkgt
real rlb,eps1

if(m>n)ERROR(Trying to calculate more eigenvalues than size of matrix)
if(large)m11=n-m+1; else m11=1 #index of smallest eigenval wanted
fv1=jstkgt(8*n,REAL); iv1=jstkgt(m,INT) #scratch for EISPAK routines
fv2=fv1+n; fv3=fv2+n; fv4=fv3+n; fv5=fv4+n; fv6=fv5+n; fv7=fv6+n; fv8=fv7+n

call stred1(n,n,A,rs(fv1),rs(fv2),rs(fv3))
eps1=0.
call tridib(n,eps1,rs(fv1),rs(fv2),rs(fv3),rlb,rub,
	m11,m,values,is(iv1),ierr,rs(fv4),rs(fv5))
if(ierr!=0)ERROR(Bisection step failed in eigenvalue calculation)
call tinvit(n,n,rs(fv1),rs(fv2),rs(fv3),m,values,is(iv1),vector,ierr,
	rs(fv4),rs(fv5),rs(fv6),rs(fv7),rs(fv8))
if(ierr!=0)ERROR(Inverse iteration step failed in eigenvalue calculation)
call trbak1(n,n,A,rs(fv2),m,vector)
call jstkrl(2)
return
end
