ROUTINE(fitden,		density estimation)
subroutine fitden(x,n,kindow,width,first,last,nout,out)
real x(1),out(1),width,first,last
integer n,nout,kindow

define(`PI',3.14159)

real xnorm,xdel,xt,step,cut,h
integer i,j,ileft

if(nout<1|n<1|width<=0)return
h=width/2.
step=(last-first)/max0((nout-1),1)	# avoid zero divide when nout==1
cut=1.	#cut half-width from center
xnorm=n*h
if(kindow==4){
	h=h/2	#width is 4 sigma
	xnorm=xnorm*.5*0.9974*sqrt(2*PI)	#adjust for area wihin 3 sigma
	cut=3.	#cut 3 sigma from center
	}
ileft=1

for(j=1; j<=nout; j=j+1){
	xt=first+(j-1)*step
	out(j)=0.
	for(i=ileft; i<=n; i=i+1){
		xdel=(x(i)-xt)/h
		if(xdel>cut)break
		if(xdel< -cut) { ileft=ileft+1; next}
		switch(kindow){
			case 1:	#rectangular
				out(j)=out(j)+.5
			case 2:	#triangular
				out(j)=out(j)+1.-abs(xdel)
			case 3:	#cosine
				out(j)=out(j)+.5*(1.+cos(xdel*PI))
			case 4:	#gaussian
				out(j)=out(j)+exp(-(xdel**2)/2.)
			}
		}
	out(j)=out(j)/xnorm
	}
return
end
