ROUTINE(gamlim,legal bounds for x in gamma(x))
subroutine gamlim(xmin,xmax)
real xmin,xmax

# april 1977 version.  w. fullerton, c3, los alamos scientific lab.
#
# calculate the minimum and maximum legal bounds for x in gamma(x).
# xmin and xmax are not the only bounds, but they are the only non-
# trivial ones to calculate.
#
#             output arguments --
# xmin   minimum legal value of x in gamma(x).  any smaller value of
#        x might result in underflow.
# xmax   maximum legal value of x in gamma(x).  any larger value will
#        cause overflow.
#
real alnsml,alnbig,xln,xold
integer i
alnsml = alog(R1MACH(1))
xmin = -alnsml
for(i=1; i<=10; i=i+1){
	xold = xmin
	xln = alog(xmin)
	xmin = xmin-xmin*((xmin+0.5)*xln-xmin-0.2258+alnsml)/(xmin*xln+0.5)
	if (abs(xmin-xold)<0.005) break
	}
if(i>10)ERROR(unable to compute xmin)
xmin = -xmin+0.01
#
alnbig = alog(R1MACH(2))
xmax = alnbig
for(i=1; i<=10; i=i+1){
	xold = xmax
	xln = alog(xmax)
	xmax = xmax-xmax*((xmax-0.5)*xln-xmax+0.9189-alnbig)/(xmax*xln-0.5)
	if (abs(xmax-xold)<0.005) break
	}
if(i>10)ERROR(unable to compute xmax)
xmax = xmax-0.01
xmin = amax1(xmin,-xmax+1.)
return
end



