ROUTINE(gamma,returns gamma(x))
real function gamma(x)
real x

# june 1977 edition.   w. fullerton, c3, los alamos scientific lab.
real gcs(23),pi,sq2pil,xmin,xmax,dxrel,y,sinpiy
real r9lgmc,csevl
integer ngcs,i,n,inits
SAVE( ngcs,xmin,xmax,dxrel )
data gcs(1)/.0085711955 90989331e0/
data gcs(2)/.0044153813 24841007e0/
data gcs(3)/.0568504368 1599363e0/
data gcs(4)/-.0042198353 96418561e0/
data gcs(5)/.0013268081 81212460e0/
data gcs(6)/-.0001893024 529798880e0/
data gcs(7)/.0000360692 532744124e0/
data gcs(8)/-.0000060567 619044608e0/
data gcs(9)/.0000010558 295463022e0/
data gcs(10)/-.0000001811 967365542e0/
data gcs(11)/.0000000311 772496471e0/
data gcs(12)/-.0000000053 542196390e0/
data gcs(13)/.0000000009 193275519e0/
data gcs(14)/-.0000000001 577941280e0/
data gcs(15)/.0000000000 270798062e0/
data gcs(16)/-.0000000000 046468186e0/
data gcs(17)/.0000000000 007973350e0/
data gcs(18)/-.0000000000 001368078e0/
data gcs(19)/.0000000000 000234731e0/
data gcs(20)/-.0000000000 000040274e0/
data gcs(21)/.0000000000 000006910e0/
data gcs(22)/-.0000000000 000001185e0/
data gcs(23)/.0000000000 000000203e0/
data pi/3.14159 26535 89793 24e0/
# sq2pil is alog (sqrt (2.*pi) )
data sq2pil/0.91893 85332 04672 74e0/
data ngcs,xmin,xmax,dxrel/0,3*0.0/
if (ngcs==0) {
# initialize.  find legal bounds for x, and determine the number of
# terms in the series required to attain an accuracy ten times better
# than machine precision.
	ngcs = inits(gcs,23,0.1*R1MACH(3))
	call gamlim(xmin,xmax)
	dxrel = sqrt(R1MACH(4))
	}
y = abs(x)
if (y>10.0) {	# compute gamma(x) for abs(x) .gt. 10.0.  recall y = abs(x).
	if(x>xmax) ERROR(overflow -- x too large)
	if (x<xmin) {
		ERROR(underflow -- x too small,zero returned,WARNING)
		return(0.)
		}
	if (x>=xmin) {
		gamma = exp((y-0.5)*alog(y)-y+sq2pil+r9lgmc(y))
		if (x<=0.) {
			if (abs((x-aint(x-0.5))/x)<dxrel)
				ERROR(answer under half precision as x near negative integer,answer returned,WARNING)
			sinpiy = sin(pi*y)
			if (sinpiy==0.) ERROR(x is a negative integer)
			gamma = -pi/(y*sinpiy*gamma)
			}
		}
	}
else {
# compute gamma(x) for abs(x) .le. 10.0.  reduce interval and
# find gamma(1+y) for 0. .le. y .lt. 1. first of all.
	n = x
	if (x<0.)
		n = n-1
	y = x-float(n)
	n = n-1
	gamma = 0.9375+csevl(2.*y-1.,gcs,ngcs)
	if (n>0)	# gamma(x) for x .ge. 2.
		do i = 1,n
			gamma = (y+float(i))*gamma
	else if(n<0) {	# compute gamma(x) for x .lt. 1.
		n = -n
		if (x==0.) ERROR(x equals zero)
		if (x<0.&&x+float(n-2)==0.) ERROR(x is a negative integer)
		if (x<(-0.5)&&abs((x-aint(x-0.5))/x)<dxrel)
			ERROR(answer under half precision as x near negative integer,answer returned,WARNING)
		do i = 1,n
			gamma = gamma/(x+float(i-1))
		}
	}
return
end
