ROUTINE(qbeta,		quantiles from the general beta distribution)
function qbeta(p,a,b)
real p,a,b
#p: probability level
#a,b: parameters

logical right
real xr,xl,pr,pl,xm,sd,pp,pdif,xx,pbeta,tol
tol=PRECISION*10.
if(a==1 & b==1) return(p)	# uniform distn
if(p<.05) { xl=0.; pl=0.; right=FALSE }
else if(p>.95) { xr=1.; pr=1.; right=TRUE }
else {	# normal approximation
	xm=a+b
	sd=sqrt((a*b)/(xm**2*(xm+1.)))
	xl=qnorms(p)*sd+a/xm
	if(xl<tol) { xl=0.; pl=0.; right=FALSE }
	else if(xl>1.-tol){ xr=1.; pr=1.; right=TRUE }
	else{
		pl=pbeta(xl,a,b)
		right=pl>p
		if(right) { pr=pl; xr=xl }
		}
	}
if(right)	# find left end
	repeat{
		xl=amax1(xr-.05,0.)
		if(xl<=0.) {pl=0.; break }
		pl=pbeta(xl,a,b)
		if(pl==p) return(xl)
		if(pl<p) break
		xr=xl; pr=pl
		}
else 	# find right end
	repeat{
		xr=amin1(xl+.05,1.)
		if(xr>=1.) {pr=1.; break }
		pr=pbeta(xr,a,b)
		if(pr==p) return(xr)
		if(pr>p) break
		xl=xr; pl=pr
		}
# now the quantile is between xl and xr ...
do i = 1,6 {	# bisection
	xx = (xl+xr)*.5
	pp = pbeta(xx,a,b)
	pdif = pp-p
	if (abs(pdif)<tol) return(xx)
	if (pdif>0.) { xr=xx; pr=pp }
	else { xl = xx; pl = pp }
	}
do i = 1,6 {	# secant method
	xx = xl+(p-pl)*(xr-xl)/(pr-pl)
	pp = pbeta(xx,a,b)
	pdif = pp-p
	if (abs(pdif)<tol) return(xx)
	if (pdif>0.) { xr = xx; pr = pp }
	else { xl = xx; pl = pp }
	}
return(xx)	# didn't converge
end
