ROUTINE(rdtfmt,find format for real number)
subroutine rdtfmt(x,n,length,nd,type)
real x(1); integer n,length,nd,type

integer neg,ne,nf,nr,nl,i,small,hugexp

nl=0; nr=0; ne=0; neg=0; small=0; hugexp=0
for(i=1; i<=n; i=i+1) { # find a format
	if(NA(x(i),REAL))next
	if(abs(x(i))>BIG)next	# watch out for infinities
	call zrrepz(x(i),il,ir,ie)
	if(x(i)<0.0)neg=1
	if(abs(x(i))<=1e-10) hugexp=1
	if(abs(x(i))>=1e+10) hugexp=1
	if(abs(x(i))<1) small=1
	nl=max0(nl,il)
	nr=max0(ir,nr)
	ne=max0(ie,ne)
	}

# f format
nf=max0(nl,1)+neg+nr+1	# digits to left of decimal, sign, to right, decimal

# e format
nd = ne-1	# 1pe format
if(ne>1) ne=ne+1	# for decimal point
ne=ne+2+neg+small+hugexp	# 2 (for 1-digit exponent, "E")
	# neg (for sign), small (for neg exponent), hugexp (for 2-dig exponent)

if(length>0 & nf>length & nf>ne) nf=100	# user specified len, f overflows, e smaller => force e 
if(nf<=ne|nf-neg<8){	# bias in favor of f format for "short" numbers
	if(length<=0) length=nf
	if(length<nf) {
		nd=max0(0,nr-(nf-length))	# how many decimals will fit?
		if(nd==0)length=nl+neg+1	# left + sign + decimal pt
		}
	else nd=nr
	type = -1
	}
else {
	if(length<ne)length=ne
	type= 1
	}
return
end
