ROUTINE(stems,set up for stemw)
subroutine stems(a,m,fc,smax1,width1,nl1,fac,same,twodig,nohead,brk,fence,integr,depth)
# sets up the options for stemw
integer m,nl1,fc,smax1,width1,width,brk
real a(m),fac,fence
logical same,twodig,integr,nohead,depth
INCLUDE(print)
integer n,k,nl,ks1,nstem,i,kkl,kku
real xm,hl,hu,al,au,s,smax,factor,stat
n = m
POSARG(n,no action taken)
call sort(a,n)
width = width1
if (width>110||width<=0) width = 110
#...quantiles, fences, and limits for the s-and-l
k = (n+1)/2
xm = (a(k)+a(n-k+1))*0.5
k = n/4+1
hl = a(k); hu = a(n-k+1)
if (mod(n,4)==0) k = k-1
hl = (hl+a(k))*0.5; hu = (hu+a(n-k+1))*0.5
if (!nohead){
	SKIP(fc)
	FPRINT(fc,"N =",I(n),"   Median =",R(xm))
	FPRINT(fc,"Quartiles =",R(hl),COMMA,R(hu))
	}
if(hl==hu){	# fix if lots of data concentrated at hinges
	for(kkl=k; kkl>1; kkl=kkl-1) if(a(kkl)!=hl) break
	for(kku=n-k+1; kku<n; kku=kku+1) if(a(kku)!=hu) break
	nleft=kkl+n-kku+1	# number of pts not==hinges
	k = nleft/4+1
	hl = a(k); hu = a(n-k+1)
	}
al = hl-fence*(hu-hl)
au = hu+fence*(hu-hl)
kkl = 0
repeat
	kkl = kkl+1
	until(a(kkl)>=al)
kku = n+1
repeat
	kku = kku-1
	until(a(kku)<=au)
if (!same||nl<=0) {	 #...scale factor:
	if (iabs(brk)<=15)
		ks1 = brk
	else {
		s = a(kku)-a(kkl)
		if (s<=0.0) {
			ks1 = 0
			nl = 10
			}
		smax = amax1(amin0(30,n-2),10.0)
		if (smax1>0)
			smax = smax1
		s = alog10(smax/s)
		if (s<0.0)
			s = s-1.0
		ks1 = s
		if (integr&&ks1>0)
			ks1 = 0
		}
#...determine nl:
	if (nl1>0) {
		nl = nl1
		if (nl==2||nl==5||nl==10)
			go to 10
		}
	factor = fac
	if (twodig)
		factor = factor*3.0
	nstem = (a(kku)-a(kkl))*10.0**ks1
	nstem = nstem+1
	stat = factor*float(n)/float(nstem**2)
	nl = 10
	if (stat>3.0) nl = 5
	if (stat>20.0) nl = 2
	if (integr&&ks1==0&&nl1==0) nl = 10
	}

10  SKIP(fc)
if (ks1==0) FPRINT(fc,"Decimal point is at the colon")
else {
	ENCODE("Decimal point is",I(iabs(ks1)))
	if(iabs(ks1)>1) ENCODE(" places to the ")
	else            ENCODE(" place to the ")
	if(ks1>0) ENCODE("left")
	else ENCODE("right")
	FPRINT(fc," of the colon")
	}
if (kkl>1) {
	SKIP(fc)
	i1=-1; call rdtfmt(a,kkl-1,i1,i2,i3)
	ENCODE("Low: ")
	for(i=1;i<kkl;i=i+1) {
		if(BUFPOS+i1>=width){ FPRINT(fc); ENCODE("Low: ") }
		ENCODE(SP(1),R(a(i),i1,i2,i3))
		}
	FPRINT(fc)
	}
SKIP(fc)
call stemw(a,n,fc,kkl,kku,ks1,nl,width,twodig,depth)
if (kku<n) {
	SKIP(fc)
	i1=-1; call rdtfmt(a(kku+1),n-kku,i1,i2,i3)
	ENCODE("High:")
	for(i=kku+1; i<=n; i=i+1) {
		if(BUFPOS+i1>=width){ FPRINT(fc); ENCODE("High:") }
		ENCODE(SP(1),R(a(i),i1,i2,i3))
		}
	FPRINT(fc)
	}
SKIP(fc)
return
end
