ROUTINE(twoway,two-way analysis by trimmed means)
subroutine twoway(x,n,p,row,col,grand,alpha,eps,mxiter,iter,change,scr)
integer n,p,mxiter,iter
real x(n,p),row(n),col(p),scr(1)	# scr must be max(n,p)
real grand,alpha,eps,change

integer i,j,n2
real xmin,xmax,t,trmnu
call narang(x,n*p,xmin,xmax)	# dies if x is all-na
xmax=amax1(abs(xmin),abs(xmax))
call rfill(0.,row,n); call rfill(0.,col,p)
for(iter=1; iter<=mxiter; iter=iter+1){
	change=0.
	for(i=1; i<=n; i=i+1){	#row effects
		call nacopy(x(i,1),n,p,scr,n2)
		if(n2>0){
			t=trmnu(scr,n2,alpha)
			row(i)=row(i)+t
			call naadj(x(i,1),n,p,t)
			change=amax1(change,abs(t))
			}
		else call setna(row(i))
		}
	for(j=1; j<=p; j=j+1){	#col effects
		call nacopy(x(1,j),1,n,scr,n2)
		if(n2>0){
			t=trmnu(scr,n2,alpha)
			col(j)=col(j)+t
			call naadj(x(1,j),1,n,t)
			change=amax1(change,abs(t))
			}
		else call setna(col(j))
		}
	if(change<=amax1(xmax*PRECISION,eps)) break
	}
call nacopy(row,1,n,scr,n2)	# now compute grand
if(n2>0) {
	grand=trmnu(scr,n2,alpha)
	call naadj(row,1,n,grand)
	}
call nacopy(col,1,p,scr,n2)
if(n2>0){
	t=trmnu(scr,n2,alpha)
	grand=grand+t
	call naadj(col,1,p,t)
	}
return
end
