#include <ctype.h>
static FILE *readfile;
define(`MAXCHAR',512)
INCLUDE(u/read)
static int quoted; /* shared between charfl & anyfld */

F77_SUB(rdopen,char=file)
{
	r_rdopen(F_CHARP(file));
}

static r_rdopen(file)
char *file;
{
	if( *file == '\0') {
		readfile = stdin;
		setbuf(stdin,NULL);	/* no buffering to avoid interference */
		}
	else if( (readfile = fopen(file,"r")) == NULL)
		FATAL(Unable to open file for reading: %s,file)
}

F77_SUB(rdclos)
{
	if(readfile!=stdin) fclose(readfile);
	clearerr(readfile);
}

F77_SUB(anyfld, int=dmode, real=rval, int=intval, int=fldlen, int=error)
{
	r_anyfld(F_INTP(dmode),F_REALP(rval),F_INTP(intval),F_INTP(fldlen),
		F_INTP(error));
}

static r_anyfld( dmode, rval, intval, fldlen, error)
long *dmode, *intval, *fldlen, *error; float *rval;
{
	extern char F77_COM(decbfc)[];
	char c,c2,c3; int flag,flag1;

	F77_CALL(charfl,int=fldlen,int=error);
	if(*error != OK)return;
	if(quoted){ *dmode = CHAR; return;}

	if(!strcmp(F77_COM(decbfc),"N`'A")){
		*dmode = GOT_NA;
		return;
		}
	c = c2 = '\0';
	c3 = F77_COM(decbfc)[*fldlen];	/* remember old char */
	F77_COM(decbfc)[*fldlen]= '\001';	/*funny char not in any input */
	sscanf(F77_COM(decbfc),"%f%c",rval,&c);
	sscanf(F77_COM(decbfc),"%ld%c",intval,&c2);
	if(c2!='\001')*dmode = (c=='\001'?REAL:CHAR);
	/* else leave as ANY */
	F77_COM(decbfc)[*fldlen]= c3;	/* put back old char */
}

F77_SUB(lglfld, int=ival, int=error)
{
	r_lglfld(F_INTP(ival),F_INTP(error));
}

static r_lglfld(ival, error)
long *ival; long *error;
{
	int flag, c;
	*error = OK; if(readfile==stdin){setprm( error ); if(*error==END_OF_FILE)return;}
	do{ c=getc(readfile); } while(isspace(c));
	if(c==EOF) { *error = END_OF_FILE; return; }
	if(c=='T') *ival = TRUE;
	else if(c=='F') *ival = FALSE;
	else if(c=='N') *ival = NA`'L;
	else *error=READ_ERROR;
	do{ c=getc(readfile); } while(isalpha(c)); /* skip rest of word */
	if(c==EOF) *error = END_OF_FILE;
}

F77_SUB(intfld, int=ival, int=error)
{
	r_intfld(F_INTP(ival),F_INTP(error));
}

static r_intfld(ival, error)
long *ival; long *error;
{
	int flag;
	*error = OK; if(readfile==stdin){setprm( error ); if(*error==END_OF_FILE)return;}
	if( (flag=fscanf(readfile,"%ld",ival)) == 1) *error = OK;
	else if(flag == EOF) *error = END_OF_FILE;
	else if( flag==0 && nafld(ival)) *error=OK; else *error=READ_ERROR;
}

F77_SUB(realfl, real=rval, int=error)
{
	r_realfl(F_REALP(rval),F_INTP(error));
}

static r_realfl(rval, error)
float *rval; long *error;
{
	int flag;
	*error = OK; if(readfile==stdin){setprm( error ); if(*error==END_OF_FILE)return;}
	if( (flag=fscanf(readfile,"%f",rval)) == 1) *error = OK;
	else if(flag == EOF) *error = END_OF_FILE;
	else if( flag==0 && nafld( (long *)rval)) *error=OK;
	else *error = READ_ERROR;
}

F77_SUB(charfl, int=fldlen, int=error)
{
	r_charfl(F_INTP(fldlen), F_INTP(error));
}

static r_charfl(fldlen, error)
long *fldlen; long *error;
{
	extern char F77_COM(decbfc)[];
	char brk; char *buf; int c,nchar;
	*error = OK; if(readfile==stdin){setprm( error ); if(*error==END_OF_FILE)return;}
	buf=F77_COM(decbfc); nchar=0;
	do { c=getc(readfile);}while(isspace(c));
	if( c=='"' | c=='\'') { quoted=TRUE; brk=c; }
	else if(c==EOF) { *error = END_OF_FILE; return; }
	else { *buf++ = c; quoted = FALSE; nchar++; }
	while ( (c=getc(readfile))!=EOF ) {
		if( (quoted && c==brk) || (!quoted && isspace(c)) )break;
		if( c=='\\'){
			c=getc(readfile); if(c==EOF)break;
			switch(c) {
			case 'n': c='\n'; break;
			case 't': c='\t'; break;
				}
			}
		*buf++ = c;
		if( (++nchar) == MAXCHAR) { *error=MAXCHAR; break; }
		}
	*fldlen = (long) nchar; *buf = '\0';
	if(c=='\n')ungetc(c,readfile);
}

static int nafld( item )
long *item;
{
	if(getc(readfile)!='N')return(FALSE);
	if(getc(readfile)!='A')return(FALSE);
	*item = NA`'L;
	return(isspace(getc(readfile)));
}

F77_SUB(flshsp)
{
	char c;
	do { c=getc(readfile); }
		while( c==' ' || c=='\t');
	if( c!='\n' )  ungetc(c,readfile); 
}


F77_SUB(xfgets, char=buf, int=length)
{
	fgets(F_CHARP(buf), (int) *F_INTP(length), readfile);
}

F77_SUB(getnsp, char=ichar, int=error)
{
	r_getnsp(F_CHARP(ichar),F_INTP(error));
}

static r_getnsp(ichar,error)
char *ichar; long *error;
{
	int c;
	do{ c = getc(readfile); } while( isspace(c));
	*ichar = (char)c;
	*error = (c==EOF)? END_OF_FILE : OK;
}

static setprm( error )
long *error;
{
	extern long F77_COM(binptd)[];
	int c;
	if(F77_COM(binptd)[0] == 0L) {
		fputs("1: ",stderr);
		if( ((c=fgetc(readfile))=='\n')&&(readfile==stdin)||c==EOF)
			{*error= END_OF_FILE; return;}
		ungetc(c,readfile);
		}
	else {
		while( (c=fgetc(readfile))==' ' || c=='\t');
		if(c=='\n'){
			fprintf(stderr,"%ld: ",F77_COM(binptd)[0]+1L);
			if( ((c=fgetc(readfile))=='\n')&&(readfile==stdin)||c==EOF)
				{*error= END_OF_FILE; return;}
			}
		ungetc(c,readfile);
		}
}

F77_SUB(rdflsh)
{
	int c;
	if( readfile!=stdin) fclose(readfile);
	else do { c=getc(readfile);} while( c!=EOF && c!='\n');
}
